/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

public final class ByteArrayBuilder {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] buf = EMPTY_BYTE_ARRAY;
    private int pos = 0;

    public byte[] getCopy() {
        if (this.pos == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] copy = new byte[this.pos];
        System.arraycopy(this.buf, 0, copy, 0, this.pos);
        return copy;
    }

    public void append(byte b) {
        if (this.pos >= this.buf.length) {
            byte[] newBuf = new byte[Math.max(4, this.buf.length * 2)];
            System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
            this.buf = newBuf;
        }
        this.buf[this.pos++] = b;
    }

    public int indexOf(byte b) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.buf[this.pos] != b) continue;
            return i;
        }
        return -1;
    }

    public int length() {
        return this.pos;
    }

    public void clear() {
        this.pos = 0;
    }
}

