/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class CommandLineLauncher {
    private CommandLineLauncher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(RawOutput launcher, String[] args) {
        PrintWriter err = new PrintWriter(System.err);
        int exitCode = 0;
        try {
            launcher.run(System.out, System.in, err, args);
        }
        catch (Exit e) {
            exitCode = e.code;
        }
        finally {
            err.flush();
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(TextOutput launcher, String[] args) {
        PrintWriter err = new PrintWriter(System.err);
        PrintWriter out = new PrintWriter(System.out);
        int exitCode = 0;
        try {
            launcher.run(out, System.in, err, args);
        }
        catch (Exit e) {
            exitCode = e.code;
        }
        finally {
            err.flush();
            out.flush();
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static Exit exit(int code) {
        return new Exit(code);
    }

    public static Exit exit() {
        return new Exit(0);
    }

    public static abstract class TextOutput
    extends CommandLineLauncher {
        public abstract void run(PrintWriter var1, InputStream var2, PrintWriter var3, String[] var4);
    }

    public static abstract class RawOutput
    extends CommandLineLauncher {
        public abstract void run(PrintStream var1, InputStream var2, PrintWriter var3, String[] var4);
    }

    public static final class Exit
    extends RuntimeException {
        public final int code;

        public Exit(int code) {
            this.code = code;
        }
    }
}

