/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.configuration.properties.FProperties;
import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.Base64Coder;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.CryptoUtil;
import com.fortify.util.FileUtil;
import com.fortify.util.InstallationConfiguration;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ConfigurationManager {
    static ILogger logger = MessageManager.getLogger(ConfigurationManager.class);
    private static final String FM_AUTHENTICATION_FILE = "/fmuser.properties";
    private static final String SERVER_PROPERTY_FILE = "/server.properties";
    static FProperties serverProps = FProperties.getServerProperties("/server.properties");
    public static final String SERVER_URL_KEY_ENDING = "server";
    public static final String PROXY_SERVER_KEY_ENDING = "proxy.server";
    public static final String PROXY_PORT_KEY_ENDING = "proxy.port";
    public static final String PROXY_USER_KEY_ENDING = "proxy.user";
    public static final String PROXY_PASS_KEY_ENDING = "proxy.pass";
    public static final String IS_CONFIGURED_KEY_ENDING = "is.configured";
    public static final String SOCKET_READ_TIMEOUT_ENDING = "SocketReadTimeoutSeconds";
    public static final String RP_TOOL_KEY = "rulepackupdate";
    public static final String MC_TOOL_KEY = "uploadclient";
    public static final String AU_TOOL_KEY = "autoupgrade";
    public static final String ONEPROXY_KEY = "oneproxy";
    public static final String RULEPACK_DAYS = "rulepack.days";
    public static final String RULEPACK_AUTO = "rulepack.auto.update";
    public static final String LAST_RULEPACK_UPDATE = "rulepack.last.check";
    public static final String INSTALL_AUTO = "install.auto.upgrade";
    public static final String RP_SERVER_URL_KEY = "rulepackupdate.server";
    public static final String RP_PROXY_SERVER_KEY = "rulepackupdate.proxy.server";
    public static final String RP_PROXY_PORT_KEY = "rulepackupdate.proxy.port";
    public static final String RP_PROXY_USER_KEY = "rulepackupdate.proxy.user";
    public static final String RP_PROXY_PASS_KEY = "rulepackupdate.proxy.pass";
    public static final String RP_SOCKET_READ_TIMEOUT_SECS_KEY = "rulepackupdate.SocketReadTimeoutSeconds";
    public static final String MC_SERVER_URL_KEY = "uploadclient.server";
    public static final String MC_PROXY_SERVER_KEY = "uploadclient.proxy.server";
    public static final String MC_PROXY_PORT_KEY = "uploadclient.proxy.port";
    public static final String MC_PROXY_USER_KEY = "uploadclient.proxy.user";
    public static final String MC_PROXY_PASS_KEY = "uploadclient.proxy.pass";
    public static final String ONEPROXY_HTTP_PROXY_SERVER_KEY = "oneproxy.http.proxy.server";
    public static final String ONEPROXY_HTTP_PROXY_PORT_KEY = "oneproxy.http.proxy.port";
    public static final String ONEPROXY_HTTP_PROXY_USER_KEY = "oneproxy.http.proxy.user";
    public static final String ONEPROXY_HTTP_PROXY_PASS_KEY = "oneproxy.http.proxy.pass";
    public static final String ONEPROXY_HTTPS_PROXY_SERVER_KEY = "oneproxy.https.proxy.server";
    public static final String ONEPROXY_HTTPS_PROXY_PORT_KEY = "oneproxy.https.proxy.port";
    public static final String ONEPROXY_HTTPS_PROXY_USER_KEY = "oneproxy.https.proxy.user";
    public static final String ONEPROXY_HTTPS_PROXY_PASS_KEY = "oneproxy.https.proxy.pass";
    public static final String OLD_MC_USER_NAME_KEY = "uploadclient.username";
    public static final String MC_AUTH_TYPE = "uploadclient.authtype";
    public static final String AU_SERVER_URL_KEY = "autoupgrade.server";
    public static final String RP_UPDATE_FROM_MANAGER = "rp.update.from.manager";
    public static final String MC_DEFAULT_SERVER_URL = "http://localhost:8180/ssc";
    public static final String RP_DEFAULT_SERVER_URL = "https://update.fortify.com";
    public static final String FPR_UPLOAD_TO_MANAGER = "fpr.upload.to.manager";
    public static final String AU_DEFAULT_SERVER_URL = "http://localhost:8180/ssc/update-site/installers";
    public static final String MC_DEFAULT_AUTH_TYPE = "PASSWORD";
    public static final String USERNAME_KEY = "username";
    public static final String SSC_CONNECT_READ_TIMEOUT = "SSC.READ.TIMEOUT";
    public static final String DEFAULT_READ_TIMEOUT = "10000";

    private ConfigurationManager() {
    }

    public static void setMCAuthenticationKey(String user, String authenticationKey) {
        ByteArrayInputStream is = null;
        FileOutputStream os = null;
        try {
            String guid = InstallationConfiguration.getGuid();
            String newpass = new StringBuffer().append(guid).append(user).append("=").append(authenticationKey).toString();
            is = new ByteArrayInputStream(newpass.getBytes("UTF-8"));
            File f = new File(ConfigurationManager.getMCAuthFilePath());
            FileUtil.mkdirs(f.getParentFile());
            if (!f.exists()) {
                f.createNewFile();
            }
            os = new FileOutputStream(f);
            CryptoUtil.encryptAndCompress((InputStream)is, (OutputStream)os, null, null);
            os.close();
        }
        catch (IOException ex) {
            try {
                throw new FortifyException(new Message(4, ex.getMessage()));
            }
            catch (Throwable throwable) {
                if (FileUtil.close(is) != null) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "setMCAuthenticationKey: Error closing input streams Config");
                }
                FileUtil.closeAgain(os);
                throw throwable;
            }
        }
        if (FileUtil.close(is) != null) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "setMCAuthenticationKey: Error closing input streams Config");
        }
        FileUtil.closeAgain(os);
    }

    public static void setMCUserName(String username) {
        ConfigurationManager.setMCAuthenticationKey(USERNAME_KEY, username);
    }

    public static String[] getMCUserInfo() {
        String[] ret;
        block12: {
            InputStream outis = null;
            BufferedReader br = null;
            InputStreamReader isr = null;
            FileInputStream fis = null;
            ret = new String[]{null, null};
            try {
                String fmAuthFile = ConfigurationManager.getMCAuthFilePath();
                File f = new File(fmAuthFile);
                if (!f.exists()) {
                    throw new FortifyException(new Message(4, 6400, new Object[0]));
                }
                fis = new FileInputStream(f);
                outis = CryptoUtil.decryptCompressed((InputStream)fis, null);
                isr = new InputStreamReader(outis, "UTF-8");
                br = new BufferedReader(isr);
                String decryptedPass = br.readLine();
                String guid = InstallationConfiguration.getGuid();
                if (decryptedPass != null && guid != null && decryptedPass.startsWith(guid)) {
                    String encrypted_password = decryptedPass.substring(guid.length());
                    int index = encrypted_password.indexOf(61);
                    if (index != -1) {
                        ret[0] = encrypted_password.substring(0, index);
                        ret[1] = encrypted_password.substring(index + 1);
                    }
                    break block12;
                }
                throw new FortifyException(new Message(4, 6400, new Object[0]));
            }
            catch (IOException ex) {
                throw new FortifyException(new Message(4, 6400, new Object[0]));
            }
            finally {
                if (FileUtil.close(br) != null) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "getMCUserInfo: Error closing input reader");
                }
                if (FileUtil.close(fis) != null) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "getMCUserInfo: Error closing input streams");
                }
                if (FileUtil.close(outis) != null) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "getMCUserInfo: Error closing input streams");
                }
                if (FileUtil.close(isr) != null) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "getMCUserInfo: Error closing input streams");
                }
            }
        }
        return ret;
    }

    private static String getMCAuthFilePath() {
        return SystemUtil.getProperty(CommonPropertyKeys.PK_AUTHENTICATION_PATH, InstallationConfiguration.getProductConfigDir()) + FM_AUTHENTICATION_FILE;
    }

    public static String getOldMCUserName() {
        return ConfigurationManager.getDecryptedServerProperty(OLD_MC_USER_NAME_KEY);
    }

    public static String getMCUserName() {
        try {
            String[] info = ConfigurationManager.getMCUserInfo();
            if (info.length >= 2 && USERNAME_KEY.equals(info[0])) {
                return info[1];
            }
            String username = SystemUtil.getProperty(CommonPropertyKeys.PK_INSTALLATION_USERNAME);
            if (username == null || "".equals(username) || "${FM.user.name}".equals(username)) {
                return System.getProperty("user.name");
            }
            return username;
        }
        catch (Exception e) {
            return System.getProperty("user.name");
        }
    }

    public static String getSocketReadTimeout() {
        return serverProps.getProperty(RP_SOCKET_READ_TIMEOUT_SECS_KEY, "180");
    }

    public static void setSscConnectReadTimeout(String value) {
        try {
            Integer.parseInt(value);
            serverProps.setProperty(SSC_CONNECT_READ_TIMEOUT, value);
        }
        catch (NumberFormatException e) {
            serverProps.setProperty(SSC_CONNECT_READ_TIMEOUT, DEFAULT_READ_TIMEOUT);
        }
    }

    public static String getSscConnectReadTimeout() {
        return serverProps.getProperty(SSC_CONNECT_READ_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String getMCServerURL() {
        return serverProps.getProperty(MC_SERVER_URL_KEY, MC_DEFAULT_SERVER_URL);
    }

    public static void setMCServerURL(String url) {
        serverProps.setProperty(MC_SERVER_URL_KEY, url);
    }

    public static String getMCAuthType() {
        return serverProps.getProperty(MC_AUTH_TYPE, MC_DEFAULT_AUTH_TYPE);
    }

    public static void setMCAuthType(String authType) {
        serverProps.setProperty(MC_AUTH_TYPE, authType);
    }

    public static String getMCProxyServer() {
        return serverProps.getProperty(MC_PROXY_SERVER_KEY);
    }

    public static String getMCProxyPort() {
        return serverProps.getProperty(MC_PROXY_PORT_KEY);
    }

    public static String getMCProxyUsername() {
        return ConfigurationManager.getDecryptedServerProperty(MC_PROXY_USER_KEY);
    }

    public static String getMCProxyPassword() {
        return ConfigurationManager.getDecryptedServerProperty(MC_PROXY_PASS_KEY);
    }

    public static String getDecryptedServerProperty(String propertyName) {
        String encryptedProperty = serverProps.getProperty(propertyName);
        if (!StringUtil.isEmpty(encryptedProperty)) {
            try {
                return Base64Coder.decryptAndDecode(encryptedProperty, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getRPServerURL() {
        return serverProps.getProperty(RP_SERVER_URL_KEY, RP_DEFAULT_SERVER_URL);
    }

    public static String getRPProxyPort() {
        return serverProps.getProperty(RP_PROXY_PORT_KEY);
    }

    public static String getRPProxyServer() {
        return serverProps.getProperty(RP_PROXY_SERVER_KEY);
    }

    public static String getRPProxyUsername() {
        return ConfigurationManager.getDecryptedServerProperty(RP_PROXY_USER_KEY);
    }

    public static String getRPProxyPassword() {
        return ConfigurationManager.getDecryptedServerProperty(RP_PROXY_PASS_KEY);
    }

    public static boolean getUpdateRPFromManager() {
        return Boolean.valueOf(serverProps.getProperty(RP_UPDATE_FROM_MANAGER, "false"));
    }

    public static boolean usingManagerForFPRUpload() {
        return Boolean.valueOf(serverProps.getProperty(FPR_UPLOAD_TO_MANAGER, "true"));
    }

    public static FProperties getServerProperties() {
        return serverProps;
    }

    public static String getOneProxyHttpProxyServer() {
        return serverProps.getProperty(ONEPROXY_HTTP_PROXY_SERVER_KEY);
    }

    public static String getOneProxyHttpProxyPort() {
        return serverProps.getProperty(ONEPROXY_HTTP_PROXY_PORT_KEY);
    }

    public static String getOneProxyHttpProxyUsername() {
        return ConfigurationManager.getDecryptedServerProperty(ONEPROXY_HTTP_PROXY_USER_KEY);
    }

    public static String getOneProxyHttpProxyPassword() {
        return ConfigurationManager.getDecryptedServerProperty(ONEPROXY_HTTP_PROXY_PASS_KEY);
    }

    public static String getOneProxyHttpsProxyServer() {
        return serverProps.getProperty(ONEPROXY_HTTPS_PROXY_SERVER_KEY);
    }

    public static String getOneProxyHttpsProxyPort() {
        return serverProps.getProperty(ONEPROXY_HTTPS_PROXY_PORT_KEY);
    }

    public static String getOneProxyHttpsProxyUsername() {
        return ConfigurationManager.getDecryptedServerProperty(ONEPROXY_HTTPS_PROXY_USER_KEY);
    }

    public static String getOneProxyHttpsProxyPassword() {
        return ConfigurationManager.getDecryptedServerProperty(ONEPROXY_HTTPS_PROXY_PASS_KEY);
    }

    public static void reload() {
        serverProps = FProperties.getServerProperties(SERVER_PROPERTY_FILE);
    }

    public static boolean isAutoRPUpdate() {
        return serverProps.getBooleanProperty(RULEPACK_AUTO, "true");
    }

    public static int getRulepackDays() {
        try {
            return Integer.valueOf(serverProps.getProperty(RULEPACK_DAYS, "15"));
        }
        catch (NumberFormatException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "IDEProperties improperly formatted", (Throwable)e);
            return 15;
        }
    }

    public static boolean isAutoAUUpdate() {
        return serverProps.getBooleanProperty(INSTALL_AUTO, "false");
    }

    public static String getAUServerURL() {
        return serverProps.getProperty(AU_SERVER_URL_KEY, AU_DEFAULT_SERVER_URL);
    }
}

