/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ConsolePasswordReader {
    static ILogger logger = MessageManager.getLogger(ConsolePasswordReader.class);
    private final String prompt;
    private final InputStream consoleIn;
    private final PrintStream consoleOut;

    public ConsolePasswordReader(String prompt, InputStream consoleIn, PrintStream consoleOut) {
        this.prompt = prompt;
        this.consoleIn = consoleIn;
        this.consoleOut = consoleOut;
        assert (prompt.length() < 80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.consoleIn));
        Eraser eraser = new Eraser();
        Thread eraserThread = new Thread((Runnable)eraser, "ConsolePasswordReader Eraser");
        eraserThread.start();
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            eraser.end();
            try {
                eraserThread.join();
            }
            catch (InterruptedException e) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "InterruptedException", (Throwable)e);
            }
            for (int i = 0; i < 80; ++i) {
                this.consoleOut.print('\b');
            }
        }
    }

    private final class Eraser
    implements Runnable {
        private boolean go = true;

        private Eraser() {
        }

        public void end() {
            this.go = false;
        }

        @Override
        public void run() {
            int i;
            StringBuffer b = new StringBuffer("\r");
            b.append(ConsolePasswordReader.this.prompt);
            for (i = 0; i < 5; ++i) {
                b.append(' ');
            }
            for (i = 0; i < 5; ++i) {
                b.append('\b');
            }
            String echo = b.toString();
            while (this.go) {
                ConsolePasswordReader.this.consoleOut.print(echo);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "InterruptedException", (Throwable)e);
                }
            }
        }
    }
}

