/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtil {
    public static SimpleDateFormat outputFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss zZ");

    public static int getDaysUntilGregorian(Date date) {
        return DateUtil.getDaysBetweenGregorian(new Date(), date);
    }

    public static int getDaysBetweenGregorian(Date d1, Date d2) {
        return DateUtil.getDaysBetween(DateUtil.getGregorianCalFromDate(d1), DateUtil.getGregorianCalFromDate(d2));
    }

    public static int getDaysBetween(Calendar d1, Calendar d2) {
        if (!d1.before(d2)) {
            return 0;
        }
        return DateUtil.getDaysBetweenIgnoreOrder(d1, d2);
    }

    public static int getDaysBetweenIgnoreOrder(Calendar d1, Calendar d2) {
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    public static GregorianCalendar getGregorianCalFromDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal;
    }

    public static synchronized String getUTFDate(Date date) {
        if (date != null) {
            return outputFormatter.format(date);
        }
        return "";
    }

    static {
        outputFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

