/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Digest {
    static ILogger logger = MessageManager.getLogger(Digest.class);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessageDigest messageDigest;
    public static boolean debug;

    private static String removeSpace(String str) {
        char[] array = str.toCharArray();
        StringBuilder tmp = new StringBuilder();
        for (char c : array) {
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) continue;
            tmp.append(c);
        }
        return tmp.toString();
    }

    public static String toHex(byte[] data) {
        StringBuilder buf = new StringBuilder(data.length * 2);
        for (byte aData : data) {
            buf.append(HEX[aData >> 4 & 0xF]);
            buf.append(HEX[aData & 0xF]);
        }
        return buf.toString();
    }

    public static synchronized String mk(String s) {
        messageDigest.reset();
        String str = Digest.removeSpace(s);
        if (str.equals("")) {
            return "<NULL>";
        }
        if (debug) {
            return str;
        }
        byte[] bytes = StringUtil.getBytes(Digest.removeSpace(s));
        byte[] hashed = messageDigest.digest(bytes);
        return Digest.toHex(hashed);
    }

    static {
        debug = false;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "unable to instantiate MD5 algorithm");
        }
    }
}

