/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.exceptions.FortifyException;
import com.fortify.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.xml.sax.SAXParseException;

public class ExceptionUtil {
    private static String RUNTIME_EXCEPTION_MESSAGE = "An internal error has occurred.";

    public static String stackTraceAsString(Throwable t) {
        return StringUtil.stackTraceToString(t);
    }

    public static String currentStackTrace() {
        return ExceptionUtil.stackTraceAsString(new Exception());
    }

    public static String getMessageFromThrowable(Throwable t) {
        return ExceptionUtil.getMessageFromThrowable(t, false);
    }

    public static String getMessageFromThrowable(Throwable t, boolean isCause) {
        String causeMessage;
        int i;
        String message;
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if ((message = t.getMessage()) == null || "".equals(message)) {
            message = t.getClass().toString();
        } else if (message.indexOf("Possible tag names are:") >= 0) {
            message = message.substring(0, message.indexOf("Possible tag names are:"));
        }
        if (ExceptionUtil.isInstance(t, "org.springframework.ws.client.WebServiceIOException") && t.getCause() != null) {
            t = t.getCause();
        }
        if ((ExceptionUtil.isInstance(t, "org.springframework.ws.client.WebServiceClientException") || ExceptionUtil.isInstance(t, "com.sun.xml.wss.impl.WssSoapFaultException")) && (i = t.getMessage().lastIndexOf(58)) > 0 && i < t.getMessage().length()) {
            return t.getMessage().substring(i + 1).trim();
        }
        if (t instanceof JAXBException) {
            JAXBException jax = (JAXBException)t;
            if (jax.getLinkedException() != null && !(jax.getLinkedException() instanceof JAXBException)) {
                message = message + "\n\n(" + ExceptionUtil.getMessageFromThrowable(jax.getLinkedException()) + ")";
            }
        } else if (t instanceof SAXParseException) {
            SAXParseException s = (SAXParseException)t;
            if (s.getSystemId() != null) {
                message = message + "\n\nFile: \"" + s.getSystemId();
            }
            message = message + "\"  (line " + s.getLineNumber() + ")";
        } else if (t instanceof UnknownHostException) {
            message = "Unknown host: " + t.getMessage();
        } else if (t instanceof ConnectException) {
            message = "Unable to connect to server.";
        } else if (t instanceof NumberFormatException) {
            message = "Number format error: " + message;
        } else if (t instanceof UnsupportedEncodingException || t instanceof IllegalCharsetNameException || t instanceof UnsupportedCharsetException) {
            message = "Unsupported text encoding: " + message;
        } else if (t instanceof SocketException) {
            message = "Networking error: " + message;
        } else if (t instanceof MalformedURLException) {
            message = "Invalid URL: " + message;
        } else if (t instanceof IOException) {
            message = "IOException: " + message;
        } else if (t instanceof NoSuchMethodException) {
            message = "No such method: " + message;
        } else if (t instanceof ClassNotFoundException) {
            message = "Class not found: " + message;
        } else if (t instanceof UnmarshalException) {
            message = t.getMessage();
            if (message == null && ((UnmarshalException)t).getLinkedException() != null) {
                message = ((UnmarshalException)t).getLinkedException().getMessage();
            }
        } else if (t instanceof FortifyException) {
            message = t.getMessage();
        } else if (t instanceof RuntimeException) {
            message = t instanceof NullPointerException ? RUNTIME_EXCEPTION_MESSAGE + "\n(Null pointer exception.)" : RUNTIME_EXCEPTION_MESSAGE + "\n(" + t.getClass().getName() + ": " + message + ")";
        }
        if (!isCause && t.getCause() != null && (causeMessage = ExceptionUtil.getMessageFromThrowable(t.getCause(), true)) != null && !causeMessage.equals(t.getMessage())) {
            message = message + "\n(" + ExceptionUtil.getMessageFromThrowable(t.getCause(), true) + ")";
        }
        return message;
    }

    private static boolean isInstance(Object o, String className) {
        return ExceptionUtil.isSubClass(o.getClass(), className);
    }

    private static boolean isSubClass(Class clazz, String className) {
        if (clazz == null) {
            return false;
        }
        if (className.equals(clazz.getName())) {
            return true;
        }
        return ExceptionUtil.isSubClass(clazz.getSuperclass(), className);
    }
}

