/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.jaxb.externalmetadata.PackInfo;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FileUtil;
import com.fortify.util.StringUtil;
import com.fortify.xml.HybridJaxbParser;
import com.fortify.xml.JAXBValidationReporter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExternalMetadataUtil {
    static ILogger logger = MessageManager.getLogger(ExternalMetadataUtil.class);
    public static final String[] EXTERNAL_METADATA_EXTENSIONS = new String[]{".xml"};
    private static List<String>[] XML_ELEMENT = new List[]{Arrays.asList("ExternalMetadataPack", "PackInfo")};
    private static String EXTERNALMETADATA_PACKAGE = "com.fortify.jaxb.externalmetadata";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackInfo getExternalMetadataPackInfo(File file) {
        PackInfo packInfo = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            packInfo = ExternalMetadataUtil.getExternalMetadataPackInfo(is);
        }
        catch (IOException iOException) {
            FileUtil.close(is);
        }
        catch (Throwable throwable) {
            FileUtil.close(is);
            throw throwable;
        }
        FileUtil.close(is);
        return packInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackInfo getExternalMetadataPackInfo(InputStream is) {
        final PackInfo[] obj = new PackInfo[]{null};
        HybridJaxbParser.ElementHandler eh = new HybridJaxbParser.ElementHandler(){

            @Override
            public void handleElement(Object o) {
                if (o instanceof PackInfo) {
                    obj[0] = (PackInfo)o;
                } else if (JAXBElement.class.isInstance(o) && ((JAXBElement)o).getValue() instanceof PackInfo) {
                    obj[0] = (PackInfo)((JAXBElement)o).getValue();
                }
            }
        };
        HybridJaxbParser.Filter filter = new HybridJaxbParser.Filter(){

            public boolean accept(List list) {
                for (List wanted : XML_ELEMENT) {
                    if (!wanted.equals(list)) continue;
                    return true;
                }
                return false;
            }
        };
        DefaultHandler ch = new DefaultHandler();
        HybridJaxbParser parser = new HybridJaxbParser(EXTERNALMETADATA_PACKAGE, eh, filter, ch);
        parser.setJaxbClassLoader(ExternalMetadataUtil.class.getClassLoader());
        JAXBValidationReporter eventHandler = new JAXBValidationReporter();
        try {
            parser.setEventHandler(eventHandler);
            parser.runParserSAX(new InputSource(is));
        }
        catch (IOException iOException) {
        }
        catch (JAXBException jAXBException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (RuntimeException re) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Exception checking external metadata pack", (Throwable)re);
        }
        catch (OutOfMemoryError oome) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error checking external metadata pack", (Throwable)oome);
        }
        finally {
            FileUtil.close(is);
        }
        return obj[0];
    }

    public static boolean isExternalMetadataFile(String path) {
        if (StringUtil.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return ExternalMetadataUtil.isExternalMetadataFile(file);
    }

    public static boolean isExternalMetadataFile(File file) {
        if (!FileUtil.isExistingFile(file)) {
            return false;
        }
        String filename = file.getName();
        for (String suffix : EXTERNAL_METADATA_EXTENSIONS) {
            if (!filename.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static File[] getExternalMetadataFiles(File directory) {
        if (!FileUtil.isExistingDirectory(directory)) {
            return null;
        }
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return ExternalMetadataUtil.isExternalMetadataFile(file);
            }
        });
        if (files == null) {
            return null;
        }
        return files;
    }
}

