/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FLock {
    private FileChannel channel;
    private FileLock lock;

    private FLock(FileChannel channel, FileLock lock) {
        this.channel = channel;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FLock acquire(File lockFile) throws IOException {
        if (lockFile == null) {
            throw new NullPointerException("lockFile");
        }
        RandomAccessFile raf = null;
        FileChannel channel = null;
        boolean closeEverything = true;
        try {
            raf = new RandomAccessFile(lockFile, "rw");
            channel = raf.getChannel();
            FileLock lock = channel.lock();
            FLock ret = new FLock(channel, lock);
            closeEverything = false;
            FLock fLock = ret;
            return fLock;
        }
        finally {
            if (closeEverything) {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static FLock acquire(File baseFile, String append) throws IOException {
        if (baseFile == null) {
            throw new NullPointerException("baseFile");
        }
        if (append == null) {
            throw new NullPointerException("append");
        }
        return FLock.acquire(new File(baseFile.getPath() + append));
    }

    public boolean release() {
        try {
            this.releaseChecked();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void releaseChecked() throws IOException {
        IOException exception;
        block6: {
            if (this.channel == null) {
                throw new IllegalStateException("already released lock");
            }
            exception = null;
            try {
                this.lock.release();
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            try {
                this.channel.close();
            }
            catch (IOException ioe) {
                if (exception != null) break block6;
                exception = ioe;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

