/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class FVDLSignatureUtil {
    static ILogger logger = MessageManager.getLogger(FVDLSignatureUtil.class);
    private static final int BUFFER_LENGTH = 8096;
    private static final int SIGNATURE_QUEUE_SIZE_MB = 1;
    private static final String SIGNATURE_VERIFIER_THREAD_NAME = "FvdlSignatureVerifier";

    public static VerifyingInputStream getVerifyingInputStream(InputStream originalInputStream) {
        return new VerifyingInputStream(originalInputStream);
    }

    public static GeneratingOutputStream getHmacOutputStream(OutputStream originalOutputStream) {
        return new GeneratingOutputStream(originalOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean verify(InputStream originalFile, InputStream signatureFile) throws IOException {
        Mac mac;
        block13: {
            mac = FVDLSignatureUtil.getMac();
            final LinkedBlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>(126);
            final AtomicBoolean isStopRequested = new AtomicBoolean();
            Thread macThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!queue.isEmpty() || !isStopRequested.get()) {
                        try {
                            byte[] bytes = (byte[])queue.poll(10L, TimeUnit.MILLISECONDS);
                            if (bytes == null) continue;
                            mac.update(bytes);
                        }
                        catch (InterruptedException e) {
                            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception while verifying signature ", (Throwable)e);
                        }
                    }
                }
            }, SIGNATURE_VERIFIER_THREAD_NAME);
            macThread.start();
            BufferedInputStream bufIn = null;
            bufIn = new BufferedInputStream(originalFile);
            byte[] buf = new byte[8096];
            int nBytesRead = 0;
            while ((nBytesRead = bufIn.read(buf)) >= 0) {
                try {
                    byte[] bytes = new byte[nBytesRead];
                    System.arraycopy(buf, 0, bytes, 0, nBytesRead);
                    queue.put(bytes);
                }
                catch (InterruptedException e) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error while verifying signature ", (Throwable)e);
                }
            }
            bufIn.close();
            FileUtil.closeAgain(bufIn);
            try {
                isStopRequested.set(true);
                macThread.join();
            }
            catch (InterruptedException e) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error while verifying signature ", (Throwable)e);
            }
            break block13;
            catch (Exception e) {
                try {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error while verifying signature ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.closeAgain(bufIn);
                    try {
                        isStopRequested.set(true);
                        macThread.join();
                    }
                    catch (InterruptedException e2) {
                        logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error while verifying signature ", (Throwable)e2);
                    }
                    throw throwable;
                }
                FileUtil.closeAgain(bufIn);
                try {
                    isStopRequested.set(true);
                    macThread.join();
                }
                catch (InterruptedException e3) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error while verifying signature ", (Throwable)e3);
                }
            }
        }
        byte[] fvdlFinal = mac.doFinal();
        byte[] sigBuf = FileUtil.loadFileAsBytes(signatureFile);
        return Arrays.equals(sigBuf, fvdlFinal);
    }

    private static Mac getMac() {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            String __AES = "rO0ABXNyAB9qYXZheC5jcnlwdG8uc3BlYy5TZWNyZXRLZXlTcGVjW0cLZuIwYU0CAAJMAAlhbGdvcml0aG10ABJMamF2YS9sYW5nL1N0cmluZztbAANrZXl0AAJbQnhwdAADQUVTdXIAAltCrPMX+AYIVOACAAB4cAAAABAdGNh2Wo+nT+pfDWZIWtDI";
            SecretKeySpec key = new SecretKeySpec(__AES.getBytes(), "AES");
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException nse) {
            throw new FortifyException(new Message(4, 1, nse.getMessage()), (Throwable)nse);
        }
        catch (InvalidKeyException ike) {
            throw new FortifyException(new Message(4, 1, ike.getMessage()), (Throwable)ike);
        }
    }

    static /* synthetic */ Mac access$200() {
        return FVDLSignatureUtil.getMac();
    }

    public static class GeneratingOutputStream
    extends FilterOutputStream {
        Mac mac = FVDLSignatureUtil.access$200();

        private GeneratingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.mac.update((byte)(b & 0xFF));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.mac.update(b, off, len);
        }

        public byte[] getHmac() {
            return this.mac.doFinal();
        }
    }

    public static class VerifyingInputStream
    extends FilterInputStream {
        Mac mac = FVDLSignatureUtil.access$200();
        private byte[] hmac;

        private VerifyingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result >= 0) {
                this.mac.update((byte)result);
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = this.in.read(b);
            if (result > 0) {
                this.mac.update(b, 0, result);
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result > 0) {
                this.mac.update(b, off, result);
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        public boolean verify(byte[] expected) {
            return Arrays.equals(this.getHmac(), expected);
        }

        public byte[] getHmac() {
            if (this.hmac == null) {
                this.hmac = this.mac.doFinal();
            }
            return this.hmac;
        }
    }
}

