/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.Tika;

public class FileCategoryUtil {
    private final List<String> textMimeTypes;
    private final Tika tika = new Tika();
    private final ILogger logger = MessageManager.getLogger(this.getClass());

    public FileCategoryUtil(List<String> textMimeTypes) {
        this.textMimeTypes = textMimeTypes;
    }

    public FileCategoryUtil() {
        this(Arrays.asList("text", "xml", "json", "x-sh", "x-bat", "javascript", "pem"));
    }

    public boolean isBinary(File file) throws IOException {
        return this.isBinaryMimeType(this.getMimeType(file));
    }

    private String getMimeType(File file) throws IOException {
        String mimeType = this.tika.detect(file);
        this.logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.DEV, "Mime-Type detected : " + mimeType + " for file: " + file.toString());
        return mimeType;
    }

    private boolean isBinaryMimeType(String mimeType) {
        return this.textMimeTypes.stream().noneMatch(a -> mimeType.endsWith((String)a) || mimeType.startsWith((String)a));
    }
}

