/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;

public class FileFilters {
    public static final FileFilter IS_FILE = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    };
    public static final FileFilter IS_DIRECTORY = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public static FileFilter and(FileFilter a, FileFilter b) {
        return new And(new FileFilter[]{a, b});
    }

    public static FileFilter and(FileFilter a, FileFilter b, FileFilter c) {
        return new And(new FileFilter[]{a, b, c});
    }

    public static FileFilter or(FileFilter a, FileFilter b) {
        return new Or(new FileFilter[]{a, b});
    }

    public static FileFilter or(FileFilter a, FileFilter b, FileFilter c) {
        return new Or(new FileFilter[]{a, b, c});
    }

    public static class ExtensionList
    implements FileFilter {
        private final Set extensions;

        public ExtensionList(Set extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File pathname) {
            return this.extensions.contains(FileUtil.getExtension(pathname));
        }
    }

    public static class Suffix
    implements FileFilter {
        private final String suffix;

        public Suffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(this.suffix);
        }
    }

    public static class Prefix
    implements FileFilter {
        private final String prefix;

        public Prefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(this.prefix);
        }
    }

    public static class Or
    implements FileFilter {
        private final FileFilter[] filters;

        public Or(FileFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(File f) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].accept(f)) continue;
                return true;
            }
            return false;
        }
    }

    public static class And
    implements FileFilter {
        private final FileFilter[] filters;

        public And(FileFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(File f) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].accept(f)) continue;
                return false;
            }
            return true;
        }
    }
}

