/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class FileUtil {
    static ILogger logger = MessageManager.getLogger(FileUtil.class);
    public static final List<String> WIN32_EXE_ORDER = Arrays.asList("com", "exe", "bat", "cmd");
    public static final List<String> CLASS_EXT_LIST = Arrays.asList("class");
    private static final Map caseInsensitiveFileCache = new HashMap();
    public static final Pattern filenameSafetyPattern = Pattern.compile("[^a-zA-Z0-9_\\-.]");
    private static final Pattern FwdSlashSeq = Pattern.compile("//+");

    private FileUtil() {
    }

    public static String getExtension(File f) {
        return FileUtil.getExtension(f.getName());
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getDirectory(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        return new File(fullPath).getParent();
    }

    public static String changeExtension(String file, String extension) {
        int dotLocation = file.lastIndexOf(".");
        return dotLocation == -1 ? file + extension : file.substring(0, dotLocation) + extension;
    }

    public static String loadFileAsString(String filename) throws IOException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            string = FileUtil.loadFileAsString(fis);
        }
        catch (Throwable throwable) {
            FileUtil.close(fis);
            throw throwable;
        }
        FileUtil.close(fis);
        return string;
    }

    public static String loadFileAsString(File file) throws FileNotFoundException, IOException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = FileUtil.loadFileAsString(fis);
        }
        catch (Throwable throwable) {
            FileUtil.close(fis);
            throw throwable;
        }
        FileUtil.close(fis);
        return string;
    }

    public static String loadFileAsString(InputStream input) throws IOException {
        String string;
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(input, "UTF-8");
            string = FileUtil.loadFileAsString(in);
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(in);
        return string;
    }

    public static String loadFileAsString(Reader input) throws IOException {
        return FileUtil.loadFileAsStringBuffer(input).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer loadFileAsStringBuffer(Reader input) throws IOException {
        StringBuffer data = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(input);){
            int chr;
            while ((chr = reader.read()) != -1) {
                data.append((char)chr);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStringToFile(String string, String fileName) throws IOException {
        FileWriter fw = null;
        BufferedWriter out = null;
        try {
            fw = new FileWriter(fileName);
            out = new BufferedWriter(fw);
            out.write(string);
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            FileUtil.close(fw);
            throw throwable;
        }
        FileUtil.close(out);
        FileUtil.close(fw);
    }

    public static boolean deleteDirectoryStructure(File directory) {
        if (directory.isDirectory()) {
            return FileUtil.deleteDirStructHelper(directory, new HashSet<String>(), null);
        }
        return false;
    }

    public static boolean deleteDirectoryStructure(File directory, Pattern pattern) {
        if (directory.isDirectory()) {
            return FileUtil.deleteDirStructHelper(directory, new HashSet<String>(), pattern);
        }
        return false;
    }

    private static boolean deleteDirStructHelper(File dir, HashSet<String> dirList, Pattern pattern) {
        try {
            String dirName = dir.getCanonicalPath();
            if (dirList.contains(dirName)) {
                return false;
            }
            dirList.add(dirName);
        }
        catch (Exception dirName) {
            // empty catch block
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtil.deleteDirStructHelper(files[i], dirList, pattern);
                continue;
            }
            if (pattern != null && !pattern.matcher(files[i].getName()).matches()) continue;
            files[i].delete();
        }
        if (dir.listFiles() != null && dir.listFiles().length == 0) {
            return dir.delete();
        }
        return false;
    }

    public static String makeFilenameSafeString(String input) {
        Matcher m = filenameSafetyPattern.matcher(input);
        StringBuffer result = new StringBuffer();
        if (input.startsWith(".")) {
            result.append("_");
        }
        while (m.find()) {
            m.appendReplacement(result, "_");
        }
        m.appendTail(result);
        return result.toString();
    }

    public static File getCommonRoot(Collection<File> files) {
        if (files.size() == 0) {
            return null;
        }
        Iterator<File> fileIterator = files.iterator();
        File root = fileIterator.next().getAbsoluteFile().getParentFile();
        block0: while (fileIterator.hasNext()) {
            File sourceFile = fileIterator.next().getAbsoluteFile();
            while (root != null) {
                for (File sourceDir = sourceFile.getParentFile(); sourceDir != null; sourceDir = sourceDir.getParentFile()) {
                    if (sourceDir.equals(root)) continue block0;
                }
                root = root.getParentFile();
            }
            break block0;
        }
        return root;
    }

    public static boolean isParent(File parent, File child) {
        for (File currentFile = child; currentFile != null; currentFile = currentFile.getParentFile()) {
            if (!currentFile.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static File getFirstExistingDirectory(File file) {
        if (file == null) {
            return null;
        }
        if (FileUtil.isExistingDirectory(file)) {
            return file;
        }
        return FileUtil.getFirstExistingDirectory(file.getParentFile());
    }

    public static String getRelativePath(File base, File fullPath) {
        LinkedList<String> pathElts = new LinkedList<String>();
        pathElts.add(fullPath.getName());
        for (File dir = fullPath.getAbsoluteFile().getParentFile(); dir != null && !dir.equals(base); dir = dir.getParentFile()) {
            if (dir.getParentFile() != null) {
                pathElts.addFirst(dir.getName());
                continue;
            }
            pathElts.addFirst(dir.getAbsolutePath());
        }
        String result = new File(StringUtil.join(pathElts.toArray(new String[pathElts.size()]), "/")).getPath();
        if (SystemUtil.isWindows()) {
            result = result.replace('\\', '/');
        }
        return result;
    }

    public static int canReadFile(File f) {
        if (!f.exists()) {
            return 224;
        }
        if (f.isDirectory()) {
            return 225;
        }
        if (!f.isFile()) {
            return 226;
        }
        if (!f.canRead()) {
            return 227;
        }
        return 0;
    }

    public static String truncateFilename(String filename, int length) {
        if (filename == null) {
            return null;
        }
        int lengthdiff = filename.length() - length;
        if (lengthdiff > 0) {
            int index = filename.indexOf(47, lengthdiff + 3);
            if (index < 0) {
                index = filename.indexOf(92, lengthdiff + 3);
            }
            if (index < 0) {
                index = lengthdiff + 3;
            }
            return "..." + filename.substring(index);
        }
        return filename;
    }

    public static String path(String a) {
        return a;
    }

    public static String path(String a, String b) {
        return a + File.separatorChar + b;
    }

    public static String path(String a, String b, String c) {
        return a + File.separatorChar + b + File.separatorChar + c;
    }

    public static String path(String a, String b, String c, String d) {
        return a + File.separatorChar + b + File.separatorChar + c + File.separatorChar + d;
    }

    public static String path(String a, String b, String c, String d, String e) {
        return a + File.separatorChar + b + File.separatorChar + c + File.separatorChar + d + File.separatorChar + e;
    }

    public static boolean isWindowsExecutable(File target) {
        return WIN32_EXE_ORDER.contains(FileUtil.getExtension(target));
    }

    public static void copyZipArchive(ZipFile source, ZipOutputStream dest, Pattern includedEntries, Pattern excludedEntries) throws IOException {
        Enumeration<? extends ZipEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (excludedEntries != null && excludedEntries.matcher(entryName).find() || includedEntries != null && !includedEntries.matcher(entryName).find()) continue;
            InputStream sourceStream = source.getInputStream(entry);
            FileUtil.copyZipEntry(entryName, dest, sourceStream);
        }
    }

    private static void copyZipEntry(String entryName, ZipOutputStream dest, InputStream source) throws IOException {
        dest.putNextEntry(new ZipEntry(entryName));
        FileUtil.copy(source, dest, false);
        source.close();
        dest.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeArchives(File source1, File source2, File out) throws IOException {
        ZipFile tempZip;
        ZipFile sourceZip;
        ZipOutputStream destStream;
        block3: {
            File temp = null;
            destStream = null;
            sourceZip = null;
            tempZip = null;
            try {
                temp = File.createTempFile("place", null);
                temp.deleteOnExit();
                FileUtil.copy(source1, temp);
                destStream = new ZipOutputStream(new FileOutputStream(out));
                tempZip = new ZipFile(temp);
                FileUtil.copyZipArchive(tempZip, destStream, null, null);
                sourceZip = new ZipFile(source2);
                FileUtil.copyZipArchive(sourceZip, destStream, null, null);
                destStream.flush();
                destStream.close();
                if (temp == null) break block3;
                temp.delete();
            }
            catch (Throwable throwable) {
                if (temp != null) {
                    temp.delete();
                }
                FileUtil.closeAgain(destStream);
                FileUtil.close(sourceZip);
                FileUtil.close(tempZip);
                throw throwable;
            }
        }
        FileUtil.closeAgain(destStream);
        FileUtil.close(sourceZip);
        FileUtil.close(tempZip);
    }

    public static String normalizeDirectorySeperators(String path) {
        if (path == null) {
            return null;
        }
        String norm = path.replace('\\', '/');
        if (norm.contains("//")) {
            norm = FwdSlashSeq.matcher(norm).replaceAll("/");
        }
        return norm;
    }

    public static IOException close(InputStream in) {
        if (in == null) {
            return null;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException close(Reader in) {
        if (in == null) {
            return null;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException closeAgain(OutputStream out) {
        if (out == null) {
            return null;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException closeAgain(InputStream out) {
        if (out == null) {
            return null;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException close(Writer writer) {
        if (writer == null) {
            return null;
        }
        try {
            writer.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException closeAgain(Writer out) {
        if (out == null) {
            return null;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException closeAgain(ZipFile out) {
        if (out == null) {
            return null;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static IOException closeAgain(FileChannel out) {
        if (out == null) {
            return null;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    @Deprecated
    public static IOException close(OutputStream out) {
        return FileUtil.closeAgain(out);
    }

    public static void copyAuditInfo(ZipFile zipFile, ZipOutputStream zipOutputStream) throws IOException {
        FileUtil.copyAuditInfo(zipFile, zipOutputStream, new String[]{"audit.xml", "VERSION", "audit.properties"});
    }

    public static void copyAuditInfo(ZipFile zipFile, ZipOutputStream zipOutputStream, String[] excludeFiles) throws IOException {
        LinkedList<String> excludeFilesList = new LinkedList<String>();
        if (excludeFiles != null) {
            for (int i = 0; i < excludeFiles.length; ++i) {
                excludeFilesList.add(excludeFiles[i].toUpperCase());
            }
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry temp = entries.nextElement();
            String entryName = temp.getName();
            if (excludeFilesList.contains(entryName.toUpperCase())) continue;
            FileUtil.copyZipEntry(zipFile, zipOutputStream, temp, entryName);
        }
        zipOutputStream.flush();
    }

    public static void copy(InputStream src, OutputStream dest) throws IOException {
        FileUtil.copy(src, dest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, boolean closeStreams) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int numRead;
            in = new BufferedInputStream(src);
            out = new BufferedOutputStream(dest);
            byte[] buf = new byte[8192];
            while ((numRead = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, numRead);
            }
        }
        finally {
            if (in != null && closeStreams) {
                in.close();
            }
            if (out != null) {
                out.flush();
                if (closeStreams) {
                    out.close();
                }
            }
        }
    }

    public static void copyDirectoryStructure(File srcDirectory, File dstDirectory) throws IOException {
        if (!srcDirectory.isDirectory()) {
            throw new IllegalArgumentException(srcDirectory.getAbsolutePath() + " is not a directory");
        }
        if (dstDirectory.exists() && !dstDirectory.isDirectory()) {
            throw new IllegalArgumentException(dstDirectory.getAbsolutePath() + " is not a directory");
        }
        FileUtil.mkdirs(dstDirectory);
        File[] fromFiles = srcDirectory.listFiles();
        if (fromFiles != null) {
            for (int i = 0; i < fromFiles.length; ++i) {
                File src = fromFiles[i];
                File dst = new File(dstDirectory, src.getName());
                if (src.isDirectory()) {
                    FileUtil.copyDirectoryStructure(src, dst);
                    continue;
                }
                if (!src.isFile()) continue;
                FileUtil.copy(src, dst);
            }
        }
    }

    public static void makeReadOnlyAndSetModificationDate(File fileOrDir, long modificationDate) {
        if (!fileOrDir.exists()) {
            throw new IllegalArgumentException(fileOrDir.getAbsolutePath() + " does not exist");
        }
        if (fileOrDir.isDirectory()) {
            File[] contents = fileOrDir.listFiles();
            if (contents != null) {
                for (int i = 0; i < contents.length; ++i) {
                    try {
                        FileUtil.makeReadOnlyAndSetModificationDate(contents[i], modificationDate);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            fileOrDir.setReadOnly();
            fileOrDir.setLastModified(modificationDate);
        }
    }

    public static void makeReadOnly(File fileOrDir) {
        if (!fileOrDir.exists()) {
            throw new IllegalArgumentException(fileOrDir.getAbsolutePath() + " does not exist");
        }
        if (fileOrDir.isDirectory()) {
            File[] contents = fileOrDir.listFiles();
            if (contents != null) {
                for (int i = 0; i < contents.length; ++i) {
                    try {
                        FileUtil.makeReadOnly(contents[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            fileOrDir.setReadOnly();
        }
    }

    public static File makeTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtil.makeTempDirectory(prefix, suffix, null);
    }

    public static File makeTempDirectory(String prefix, String suffix, File dir) throws IOException {
        File f;
        while (!(f = File.createTempFile(prefix, suffix, dir)).delete() || !f.mkdir()) {
        }
        return f;
    }

    public static boolean isZipFile(String fileName) {
        return FileUtil.isZipFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(File file) {
        boolean bl;
        ZipInputStream zip = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            zip = new ZipInputStream(stream);
            ZipEntry zipEntry = zip.getNextEntry();
            bl = zipEntry != null;
            FileUtil.close(zip);
        }
        catch (IOException e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            FileUtil.close(zip);
            FileUtil.close(stream);
        }
        FileUtil.close(stream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractRulepacksZip(File file, String fortifyCore, Pattern pattern, FilesToInclude include) throws FortifyException, IOException {
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "extracting zip..." + file.getAbsolutePath());
        ZipInputStream zipInput = new ZipInputStream(new FileInputStream(file));
        try {
            FileUtil.extractRulepacksZip(zipInput, fortifyCore, pattern, include);
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "done extracting");
        }
        finally {
            if (FileUtil.close(zipInput) != null) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "extractRulepacksZip: Error closing input stream\n");
            }
        }
    }

    public static void extractRulepacksZip(ZipInputStream zipDataInput, String fortifyCore, Pattern pattern, FilesToInclude include) throws FortifyException, IOException {
        ZipEntry dataEntry;
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "in extracting");
        while ((dataEntry = zipDataInput.getNextEntry()) != null) {
            String name = dataEntry.getName();
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "updating: " + name);
            if (dataEntry.isDirectory()) continue;
            if (include == FilesToInclude.RulesOnly || include == FilesToInclude.RulesAndMetadata) {
                Matcher matcher = pattern.matcher(name);
                boolean valid = matcher.matches();
                if (name.contains("..")) {
                    valid = false;
                }
                if (valid) {
                    int indexOfBS;
                    int indexOfFS = name.lastIndexOf(47);
                    int index = indexOfFS >= (indexOfBS = name.lastIndexOf(92)) ? indexOfFS : indexOfBS;
                    String rpname = index != -1 ? name.substring(index) : File.separator + name;
                    FileUtil.extractEntry(zipDataInput, fortifyCore + File.separator + "config" + File.separator + "rules" + rpname);
                }
            }
            if (include != FilesToInclude.MetadataOnly && include != FilesToInclude.RulesAndMetadata || !dataEntry.getName().contains("ExternalMetadata")) continue;
            String externalMetadataName = File.separator + "externalmetadata.xml";
            FileUtil.extractEntry(zipDataInput, fortifyCore + File.separator + "config" + File.separator + "ExternalMetadata" + externalMetadataName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countFilesInZipFile(String rulePackZipFile, Pattern fileNameMatcher) throws IOException {
        int n;
        File file = new File(rulePackZipFile);
        ZipInputStream zip = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            zip = new ZipInputStream(stream);
            int countMatches = 0;
            ZipEntry dataEntry = null;
            while ((dataEntry = zip.getNextEntry()) != null) {
                String nextName = dataEntry.getName();
                if (dataEntry.isDirectory() || !fileNameMatcher.matcher(nextName).matches()) continue;
                ++countMatches;
            }
            n = countMatches;
        }
        catch (Throwable throwable) {
            FileUtil.close(zip);
            FileUtil.close(stream);
            throw throwable;
        }
        FileUtil.close(zip);
        FileUtil.close(stream);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyZipEntry(File zipFile, String name, OutputStream dest) throws IOException {
        FileInputStream is = null;
        ZipInputStream zis = null;
        try {
            is = new FileInputStream(zipFile);
            zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null && !ze.getName().equals(name)) {
                ze = zis.getNextEntry();
            }
            if (ze == null) {
                throw new FileNotFoundException(zipFile.getPath() + ":" + name);
            }
            FileUtil.copy(zis, dest, false);
        }
        catch (Throwable throwable) {
            FileUtil.close(is);
            FileUtil.close(zis);
            throw throwable;
        }
        FileUtil.close(is);
        FileUtil.close(zis);
    }

    public static void copyZipEntry(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry temp, String entryName) throws IOException {
        InputStream in = zipFile.getInputStream(temp);
        FileUtil.writeZipEntry(zipOutputStream, entryName, in);
        in.close();
    }

    public static void writeZipEntry(ZipOutputStream zipOutputStream, String entryName, InputStream in) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(entryName));
        FileUtil.copy(in, zipOutputStream, false);
        zipOutputStream.closeEntry();
    }

    private static void extractEntry(ZipInputStream zip, String destFileName) throws FortifyException {
        BufferedOutputStream out = null;
        try {
            int numRead;
            File destFile = new File(destFileName);
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Update installed rulepack: " + destFile.getName());
            FileUtil.mkdirs(destFile.getParentFile());
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] buf = new byte[8192];
            while ((numRead = zip.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, numRead);
            }
            out.flush();
            out.close();
        }
        catch (FileNotFoundException ex) {
            throw new FortifyException(new Message(4, 6231, ex.toString()));
        }
        catch (IOException ex) {
            throw new FortifyException(new Message(4, 6231, ex.toString()));
        }
        finally {
            if (FileUtil.closeAgain(out) != null) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "extractEntry: Error closing output stream\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (dest.exists() && !dest.isDirectory()) {
                throw new IllegalArgumentException("Cannot copy directory to non-directory");
            }
            FileUtil.mkdirs(dest);
            File[] srcFiles = src.listFiles();
            if (srcFiles == null) return;
            int i = 0;
            while (i < srcFiles.length) {
                File file = srcFiles[i];
                FileUtil.copy(file, new File(dest, file.getName()));
                ++i;
            }
            return;
        }
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (dest.getParentFile() != null) {
            FileUtil.mkdirs(dest.getParentFile());
        }
        FileInputStream srcStream = null;
        FileOutputStream destStream = null;
        try {
            srcStream = new FileInputStream(src);
            destStream = new FileOutputStream(dest);
            FileUtil.copy(srcStream, destStream);
            destStream.close();
        }
        catch (Throwable throwable) {
            FileUtil.close(srcStream);
            FileUtil.closeAgain(destStream);
            throw throwable;
        }
        FileUtil.close(srcStream);
        FileUtil.closeAgain(destStream);
    }

    public static boolean readFully(InputStream in, byte[] data, int offset, int length) throws IOException {
        int readAmount;
        int pos = offset;
        for (int remaining = length; remaining > 0; remaining -= readAmount) {
            readAmount = in.read(data, pos, remaining);
            if (readAmount <= 0) {
                return false;
            }
            pos += readAmount;
        }
        return true;
    }

    public static boolean readFully(InputStream in, byte[] data) throws IOException {
        return FileUtil.readFully(in, data, 0, data.length);
    }

    public static byte[] loadFileAsBytes(File file) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = FileUtil.loadFileAsBytes(fis);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileAsBytes(InputStream input) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] data = new byte[1024];
            while ((bytesRead = input.read(data)) >= 0) {
                bytes.write(data, 0, bytesRead);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        finally {
            input.close();
            bytes.close();
        }
    }

    public static int findLastIndex(String searchString, String sourceString) {
        if (searchString == null || sourceString == null) {
            return -1;
        }
        return FileUtil.findLastIndexHelper(searchString, sourceString, 0);
    }

    private static int findLastIndexHelper(String searchString, String sourceString, int startIndex) {
        int index = sourceString.indexOf(searchString, startIndex);
        if (index == -1) {
            return index;
        }
        int lastIndexMaybe = FileUtil.findLastIndexHelper(searchString, sourceString, index + 1);
        if (lastIndexMaybe == -1) {
            return index;
        }
        return lastIndexMaybe;
    }

    public static IOException close(ZipFile zip) {
        if (zip == null) {
            return null;
        }
        try {
            zip.close();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static String getShortFileName(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        String normalizedPath = FileUtil.normalizeDirectorySeperators(fullPath);
        int lastSlash = normalizedPath.lastIndexOf("/");
        if (lastSlash == -1) {
            return fullPath;
        }
        return normalizedPath.substring(lastSlash + 1);
    }

    public static String removeExtension(String shortName) {
        int lastDot = shortName.lastIndexOf(46);
        if (lastDot > 0) {
            shortName = shortName.substring(0, lastDot);
        }
        return shortName;
    }

    public static boolean mkdirs(File file) {
        File canon;
        if (file.exists()) {
            return file.isDirectory();
        }
        if (file.mkdir()) {
            return true;
        }
        try {
            canon = file.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parent = canon.getParentFile();
        FileUtil.mkdirs(parent);
        if (parent.isDirectory()) {
            canon.mkdir();
        }
        return file.isDirectory();
    }

    public static void ensurePathExists(String path) {
        File workDir = new File(path);
        if (!workDir.exists()) {
            try {
                if (!FileUtil.mkdirs(workDir)) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error creating path");
                }
            }
            catch (SecurityException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error creating path", (Throwable)e);
            }
        }
    }

    public static PrintWriter makeUTF8Writer(OutputStream os) {
        try {
            return new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported!");
        }
    }

    public static File getCaseInsensitiveFile(File f) {
        Stack<File> parents = new Stack<File>();
        File p = new File(f.getAbsolutePath());
        do {
            File fromCache;
            if ((fromCache = (File)caseInsensitiveFileCache.get(p.getAbsolutePath().toLowerCase())) != null) {
                p = fromCache;
            }
            parents.push(p);
        } while (!(p = p.getParentFile()).exists());
        block1: while (p != null && p.isDirectory() && !parents.empty()) {
            File child = (File)parents.pop();
            File[] files = p.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File s = files[i];
                    if (!child.getName().equalsIgnoreCase(s.getName())) continue;
                    p = s;
                    caseInsensitiveFileCache.put(p.getAbsolutePath().toLowerCase(), p);
                    continue block1;
                }
            }
            return null;
        }
        return p;
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean isExistingFile(String path) {
        return path != null && FileUtil.isExistingFile(new File(path));
    }

    public static boolean isExistingFile(File file) {
        return FileUtil.exists(file) && file.isFile();
    }

    public static boolean isExistingDirectory(String path) {
        return path != null && FileUtil.isExistingDirectory(new File(path));
    }

    public static boolean isExistingDirectory(File file) {
        return FileUtil.exists(file) && file.isDirectory();
    }

    public static boolean isRoot(File file) {
        File[] roots;
        if (!FileUtil.exists(file)) {
            return false;
        }
        for (File root : roots = File.listRoots()) {
            if (!root.equals(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLongestEntry(File zipFile, String entryExtension) throws IOException {
        String longestName = "";
        String extension = entryExtension == null ? "" : entryExtension;
        FileInputStream is = null;
        ZipInputStream zis = null;
        try {
            is = new FileInputStream(zipFile);
            zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String name = ze.getName();
                if (longestName.length() < name.length() && name.endsWith(extension)) {
                    longestName = name;
                }
                ze = zis.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(zis);
            throw throwable;
        }
        FileUtil.close(zis);
        return longestName;
    }

    public static File[] listFiles(File file) {
        File[] children = new File[]{};
        if (FileUtil.isExistingDirectory(file)) {
            File[] arr = file.listFiles();
            children = arr != null ? arr : children;
        }
        return children;
    }

    public static Collection<File> convertPathsToFiles(Collection<String> filePaths) {
        if (filePaths != null) {
            ArrayList<File> files = new ArrayList<File>(filePaths.size());
            for (String path : filePaths) {
                files.add(new File(path));
            }
            return files;
        }
        return Collections.emptyList();
    }

    public static Collection<String> getFilePaths(Collection<File> files) {
        if (files != null) {
            ArrayList<String> paths = new ArrayList<String>(files.size());
            for (File file : files) {
                paths.add(file.getAbsolutePath());
            }
            return paths;
        }
        return Collections.emptyList();
    }

    public static class ExtensionComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return this.compare((String)o1, (String)o2);
            }
            if (o1 instanceof File && o2 instanceof File) {
                return this.compare(((File)o1).getName(), ((File)o2).getName());
            }
            throw new IllegalArgumentException("Cannot compare extensions of " + o1.getClass() + ", " + o2.getClass());
        }

        private int compare(String s1, String s2) {
            String e1 = FileUtil.getExtension(s1);
            String e2 = FileUtil.getExtension(s2);
            int i1 = WIN32_EXE_ORDER.indexOf(e1);
            int i2 = WIN32_EXE_ORDER.indexOf(e2);
            if (i1 == -1) {
                i1 = WIN32_EXE_ORDER.size();
            }
            if (i2 == -1) {
                i2 = WIN32_EXE_ORDER.size();
            }
            if (i1 != i2) {
                return i1 < i2 ? -1 : 1;
            }
            return s1.compareTo(s2);
        }
    }

    public static enum FilesToInclude {
        RulesOnly,
        MetadataOnly,
        RulesAndMetadata;

    }
}

