/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class Func<P, R> {
    static ILogger logger = MessageManager.getLogger(Func.class);
    private static final Func<Object, Object> IDENTITY_FUNC = new Func<Object, Object>(){

        @Override
        public Object apply(Object param) {
            return param;
        }
    };

    public abstract R apply(P var1);

    public static <T> Func<T, T> identity() {
        return IDENTITY_FUNC;
    }

    public static <P, R> Func<P, R> constant(final R ret) {
        return new Func<P, R>(){

            @Override
            public R apply(P param) {
                return ret;
            }
        };
    }

    public static <T, R, CR extends Collection<? super R>> CR map2(Collection<? extends T> source, Func<T, R> func) {
        return func.map2(source);
    }

    public <CR extends Collection<? super R>> CR map2(Collection<? extends P> source) {
        Collection dest;
        assert (source != null);
        try {
            dest = (Collection)source.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to instantiate " + source.getClass().getName() + " with a zero-argument constructor", ex);
        }
        return (CR)this.map(source, dest);
    }

    public static <T, R, CR extends Collection<? super R>> CR map(Iterable<? extends T> source, CR dest, Func<? super T, R> func) {
        return func.map(source, dest);
    }

    public <CR extends Collection<? super R>> CR map(Iterable<? extends P> source, CR dest) {
        assert (source != null);
        assert (dest != null);
        for (P element : source) {
            dest.add(this.apply(element));
        }
        return dest;
    }

    public static <T, R> Collection<R> map(Collection<T> list, Func<T, R> func) {
        return func.map(list);
    }

    public Collection<R> map(Collection<P> list) {
        ArrayList<R> result;
        try {
            result = (ArrayList<R>)list.getClass().newInstance();
        }
        catch (Exception e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unable to create new instance of collection, using ArrayList", (Throwable)e);
            result = new ArrayList<R>();
        }
        for (P element : list) {
            result.add(this.apply(element));
        }
        return result;
    }

    public static <T> T[] map(T[] list, Func<T, T> func) {
        Object[] result = (Object[])Array.newInstance(list.getClass().getComponentType(), list.length);
        for (int i = 0; i < list.length; ++i) {
            result[i] = func.apply(list[i]);
        }
        return result;
    }

    public static <P, R> R[] map(P[] list, Func<P, R> func, Class<R> returnType) {
        return func.map(list, returnType);
    }

    public R[] map(P[] list, Class<R> returnType) {
        Object[] result = (Object[])Array.newInstance(returnType, list.length);
        for (int i = 0; i < list.length; ++i) {
            result[i] = this.apply(list[i]);
        }
        return result;
    }

    public static <T> void mapInPlace(List<T> list, Func<T, T> func) {
        Func.mapInPlace(list.listIterator(), func);
    }

    public static <T> void mapInPlace(ListIterator<T> li, Func<T, T> func) {
        while (li.hasNext()) {
            T result = func.apply(li.next());
            li.set(result);
        }
    }

    public static <T> void mapInPlace(T[] list, Func<T, T> func) {
        for (int i = 0; i < list.length; ++i) {
            list[i] = func.apply(list[i]);
        }
    }

    public static <T> Collection<T> filter(Collection<T> list, Func<T, Boolean> func) {
        ArrayList<T> result;
        try {
            result = (ArrayList<T>)list.getClass().newInstance();
        }
        catch (Exception e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unable to create new instance of collection, using ArrayList", (Throwable)e);
            result = new ArrayList<T>();
        }
        for (T element : list) {
            Boolean doAdd = func.apply(element);
            assert (doAdd != null);
            if (doAdd == null || !doAdd.booleanValue()) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> T[] filter(T[] list, Func<T, Boolean> func) {
        ArrayList<T> resultList = new ArrayList<T>(list.length);
        for (T element : list) {
            Boolean doAdd = func.apply(element);
            assert (doAdd != null);
            if (doAdd == null || !doAdd.booleanValue()) continue;
            resultList.add(element);
        }
        Object[] result = (Object[])Array.newInstance(list.getClass().getComponentType(), resultList.size());
        resultList.toArray(result);
        return result;
    }

    public static <T> void filterInPlace(Iterable<T> list, Func<T, Boolean> func) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T element = it.next();
            Boolean keep = func.apply(element);
            if (keep != null && keep.booleanValue()) continue;
            it.remove();
        }
    }
}

