/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public final class IndentPrinter
extends PrintWriter {
    private int indentSize;
    private int prefix;
    private boolean nl;
    private static final int DEFAULT_INDENT_SIZE = 2;
    private static final String SPACES = "                                                                                                ";

    public IndentPrinter(Writer out, int indentSize, int startSpaces, boolean freshLine) {
        super(out);
        this.indentSize = indentSize;
        this.prefix = startSpaces;
        this.nl = freshLine;
    }

    public IndentPrinter(Writer out, int indentSize, int startSpaces) {
        this(out, indentSize, startSpaces, true);
    }

    public IndentPrinter(Writer out, int indentSize) {
        this(out, indentSize, 0);
    }

    public IndentPrinter(Writer out) {
        this(out, 2);
    }

    public IndentPrinter(PrintStream out, int indentSize, int startSpaces, boolean freshLine) {
        super(out);
        this.indentSize = indentSize;
        this.prefix = startSpaces;
        this.nl = freshLine;
    }

    public IndentPrinter(PrintStream out, int indentSize, int startSpaces) {
        this(out, indentSize, startSpaces, true);
    }

    public IndentPrinter(PrintStream out, int indentSize) {
        this(out, indentSize, 0);
    }

    public IndentPrinter(PrintStream out) {
        this(out, 2);
    }

    public void indent(int amount) {
        this.prefix += amount * this.indentSize;
    }

    public void indent() {
        this.prefix += this.indentSize;
    }

    public void dedent(int amount) {
        int delta = amount * this.indentSize;
        this.prefix = Math.max(0, this.prefix - delta);
    }

    public void dedent() {
        int delta = this.indentSize;
        this.prefix = Math.max(0, this.prefix - delta);
    }

    @Override
    public void print(String v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(char[] v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(Object v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(char v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(int v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(long v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(double v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(float v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void print(boolean v) {
        this.pre();
        super.print(v);
    }

    @Override
    public void println(String v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(char[] v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(Object v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(char v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(int v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(long v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(double v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(float v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println(boolean v) {
        this.pre();
        super.println(v);
        this.nl = true;
    }

    @Override
    public void println() {
        super.println();
        this.nl = true;
    }

    @Override
    public void write(char[] buf) {
        this.pre();
        super.write(buf);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.pre();
        super.write(buf, off, len);
    }

    public void write(char c) {
        this.pre();
        super.write(c);
    }

    @Override
    public void write(String s) {
        this.pre();
        super.write(s);
    }

    @Override
    public void write(String s, int off, int len) {
        this.pre();
        super.write(s, off, len);
    }

    private void pre() {
        if (this.nl) {
            this.printIndent();
            this.nl = false;
        }
    }

    private void printIndent() {
        int remaining;
        int length = SPACES.length();
        for (remaining = this.prefix; remaining > length; remaining -= length) {
            super.write(SPACES);
        }
        super.write(SPACES, 0, remaining);
    }
}

