/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.FileUtil;
import com.fortify.util.ShellUtil;
import com.fortify.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;

public class InstallationConfiguration {
    static ILogger logger = MessageManager.getLogger(InstallationConfiguration.class);
    private static String fortifyWorkingDir = null;
    private static final String PRODUCT = CommonPropertyKeys.PK_PRODUCT_NAME.key;
    private static final String SERVER_GUI = CommonPropertyKeys.PK_DISABLE_SERVER_CONFIG.key;
    private static final String FORCE_RULEPACK_UPDATE = CommonPropertyKeys.PK_FORCE_RULEPACK_UPDATE.key;
    private static final String GUID = CommonPropertyKeys.PK_GUID.key;
    private static boolean installPropsLoaded = false;
    private static String productType = null;
    private static boolean disableServerGUI = false;
    private static boolean forceRulePackUpdate = false;
    private static String guid = null;
    private static Pattern productTypeValidator = Pattern.compile("(\\w|[ \\(\\)\\.-])*");

    public static String getFortifyWorkingDir() {
        if (fortifyWorkingDir == null) {
            Properties sysProps;
            File defaultFortifyDir = null;
            if (SystemUtil.isWindows()) {
                try {
                    String localAppdata = System.getProperty("win32.LocalAppdata");
                    if (localAppdata == null) {
                        localAppdata = ShellUtil.getLocalAppdataPath();
                        if (localAppdata == null) {
                            localAppdata = System.getProperty("user.dir");
                        }
                        System.setProperty("win32.LocalAppdata", localAppdata);
                        SystemUtil.reassessVariableSubstitution();
                    }
                    if (localAppdata != null) {
                        defaultFortifyDir = new File(localAppdata, "Fortify");
                    }
                }
                catch (Exception e) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error loading local app data path", (Throwable)e);
                }
            }
            if (defaultFortifyDir == null) {
                String defaultUserHome = SystemUtil.getProperty(CommonPropertyKeys.PK_USER_HOME);
                defaultFortifyDir = defaultUserHome != null ? new File(defaultUserHome, ".fortify") : new File(".fortify");
            }
            fortifyWorkingDir = (sysProps = System.getProperties()).containsKey(CommonPropertyKeys.PK_FORTIFY_WORKDIR.key) ? (String)sysProps.get(CommonPropertyKeys.PK_FORTIFY_WORKDIR.key) : SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_WORKDIR, defaultFortifyDir.getAbsolutePath());
            FileUtil.ensurePathExists(fortifyWorkingDir);
        }
        return fortifyWorkingDir;
    }

    public static String getProductLogDirectory(String productType) {
        String path = InstallationConfiguration.getProductWorkingDirectory(productType) + File.separatorChar + "log";
        FileUtil.ensurePathExists(path);
        return path;
    }

    public static String getProductLogDirectory() {
        return InstallationConfiguration.getProductLogDirectory(InstallationConfiguration.getProductType());
    }

    public static String getProductWorkingDirectory(String productType) {
        if (productType.indexOf("DE") != -1) {
            productType = "IDE" + File.separatorChar + productType;
        }
        productType = InstallationConfiguration.validate(productType);
        String path = InstallationConfiguration.getFortifyWorkingDir() + File.separatorChar + productType;
        FileUtil.ensurePathExists(path);
        return path;
    }

    private static String validate(String productType) {
        if (productTypeValidator.matcher(productType).matches() && productType.indexOf(0) < 0 && productType.indexOf("%00") < 0 && productType.indexOf(0) < 0 && productType.indexOf("..") < 0 && productType.indexOf(92) < 0 && productType.indexOf(47) < 0) {
            return productType;
        }
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Possible path manipulation or command injection: " + productType);
        return "tools";
    }

    public static String getProductWorkingDirectory() {
        return InstallationConfiguration.getProductWorkingDirectory(InstallationConfiguration.getProductType());
    }

    public static String getProjectWorkingDirectory(String projectName) {
        return InstallationConfiguration.getProjectWorkingDirectory(projectName, InstallationConfiguration.getProductWorkingDirectory());
    }

    public static String getProjectWorkingDirectory(String projectName, String productWorkingDirectory) {
        String path = productWorkingDirectory + File.separatorChar + projectName;
        FileUtil.ensurePathExists(path);
        return path;
    }

    public static String getProductConfigDir() {
        String configDir = InstallationConfiguration.getFortifyWorkingDir() + File.separator + "config" + File.separatorChar + InstallationConfiguration.getProductType();
        FileUtil.ensurePathExists(configDir);
        return configDir;
    }

    public static File getInstallPropsFile() {
        return new File(SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE), "/config/installation.properties");
    }

    public static void checkGUID() throws FortifyException {
        File propsFile = InstallationConfiguration.getInstallPropsFile();
        if (!propsFile.exists()) {
            FileOutputStream fos = null;
            try {
                propsFile.createNewFile();
                fos = new FileOutputStream(propsFile);
                Properties props = new Properties();
                props.put(CommonPropertyKeys.PK_GUID.key, UUID.randomUUID().toString());
                props.store(fos, null);
                fos.close();
            }
            catch (IOException e) {
                try {
                    throw new FortifyException(new Message(4, "Unable to repair installation.properties file.  Please run scapostinstall at least once with a user that has permissions to write to the install directory (" + propsFile.getAbsolutePath() + ")."), (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.closeAgain(fos);
                    throw throwable;
                }
            }
            FileUtil.closeAgain(fos);
        }
    }

    /*
     * Loose catch block
     */
    public static void loadInstallationProperties() {
        InstallationConfiguration.checkGUID();
        Properties installProps = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(InstallationConfiguration.getInstallPropsFile());
            installProps.load(fin);
        }
        catch (FileNotFoundException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Installation Properties could not be found" + e.getMessage());
            FileUtil.close(fin);
        }
        catch (IOException e2) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Installation Properties could not be loaded" + e2.getMessage());
            {
                catch (Throwable throwable) {
                    FileUtil.close(fin);
                    throw throwable;
                }
            }
            FileUtil.close(fin);
        }
        FileUtil.close(fin);
        guid = installProps.getProperty(GUID);
        productType = installProps.getProperty(PRODUCT, productType);
        disableServerGUI = Boolean.valueOf(installProps.getProperty(SERVER_GUI, "false"));
        forceRulePackUpdate = Boolean.valueOf(installProps.getProperty(FORCE_RULEPACK_UPDATE, "false"));
    }

    public static String getProductType() {
        if (!installPropsLoaded) {
            InstallationConfiguration.loadInstallationProperties();
            if (productType == null) {
                productType = "tools";
            }
            productType = InstallationConfiguration.validate(productType);
        }
        return productType;
    }

    public static boolean getServerGUIDisabled() {
        if (!installPropsLoaded) {
            InstallationConfiguration.loadInstallationProperties();
        }
        return disableServerGUI;
    }

    public static boolean getForceRulePackUpdate() {
        if (!installPropsLoaded) {
            InstallationConfiguration.loadInstallationProperties();
        }
        return forceRulePackUpdate;
    }

    public static String getGuid() {
        if (!installPropsLoaded) {
            InstallationConfiguration.loadInstallationProperties();
        }
        return guid;
    }

    public static void setProductType(String s) {
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Product: " + s);
        productType = s;
    }
}

