/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MobileBuildSessionInfo {
    static ILogger logger = MessageManager.getLogger(MobileBuildSessionInfo.class);
    public static final String ManifestEntryName = "MobileBuildSession.manifest";
    public static final String SCAVersionKey = "SCAVersion";
    public static final String BuildIDKey = "BuildID";
    public static final String BuildDirKey = "BuildDir";
    private final String scaVersion;
    private final String buildID;
    private final String buildDirectory;

    public static MobileBuildSessionInfo loadFromInputStream(InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(ManifestEntryName)) continue;
            return MobileBuildSessionInfo.loadFromManifest(zis);
        }
        logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "No manifest found");
        return null;
    }

    private static MobileBuildSessionInfo loadFromManifest(InputStream is) throws IOException {
        Properties manifest = new Properties();
        manifest.load(is);
        if (manifest.getProperty(SCAVersionKey) == null) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Manifest is missing required key SCAVersion");
            return null;
        }
        if (manifest.getProperty(BuildIDKey) == null) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Manifest is missing required key BuildID");
            return null;
        }
        if (manifest.getProperty(BuildDirKey) == null) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Manifest is missing required key BuildDir");
            return null;
        }
        return new MobileBuildSessionInfo(manifest.getProperty(SCAVersionKey), manifest.getProperty(BuildIDKey), manifest.getProperty(BuildDirKey));
    }

    private MobileBuildSessionInfo(String scaVersion, String buildID, String buildDirectory) {
        this.scaVersion = scaVersion;
        this.buildID = buildID;
        this.buildDirectory = buildDirectory;
    }

    public String getScaVersion() {
        return this.scaVersion;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }
}

