/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiSetMap<K, V> {
    private final Map<K, Set<V>> fInternalMap;
    private final Object fLock = new Object();

    public MultiSetMap() {
        this.fInternalMap = new ConcurrentHashMap<K, Set<V>>();
    }

    public void putIntoList(K key, V value) {
        this.internalGetSet(key).add(value);
    }

    public void putAllIntoSet(K key, Collection<V> values) {
        this.internalGetSet(key).addAll(values);
    }

    public Set<V> getSet(K key) {
        return this.fInternalMap.get(key);
    }

    public Set<K> keySet() {
        return this.fInternalMap.keySet();
    }

    public Collection<Set<V>> values() {
        return this.fInternalMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<V> internalGetSet(K key) {
        Object object = this.fLock;
        synchronized (object) {
            Set<Object> set = this.fInternalMap.get(key);
            if (set == null) {
                set = Collections.synchronizedSet(new HashSet());
                this.fInternalMap.put(key, set);
            }
            return set;
        }
    }
}

