/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.io.rule.Description;
import com.fortify.io.rule.DescriptionTextElement;
import com.fortify.io.rule.Reference;
import com.fortify.io.rule.References;
import com.fortify.io.rule.Tips;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.system.Version;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.castor.mapping.BindingType;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;

public class NamedDescriptionElements
implements Serializable {
    static ILogger logger = MessageManager.getLogger(NamedDescriptionElements.class);
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final boolean warnOnDuplicates;
    private static XMLClassDescriptorResolver cdr;

    public NamedDescriptionElements(boolean warnOnDuplicates) {
        this.warnOnDuplicates = warnOnDuplicates;
    }

    public Object get(String name) {
        return this.map.get(name);
    }

    public void merge(NamedDescriptionElements other) {
        for (Map.Entry<String, Object> entry : other.map.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    public void put(Description value) {
        this.putInternal(value.getId(), value);
    }

    public void put(DescriptionTextElement value) {
        this.putInternal(value.getId(), value);
    }

    public void put(Tips value) {
        this.putInternal(value.getId(), value);
    }

    public void put(Reference value) {
        this.putInternal(value.getId(), value);
    }

    public void put(References value) {
        this.putInternal(value.getId(), value);
    }

    private void putInternal(String name, Object value) {
        Object ex = this.map.get(name);
        if (ex == null) {
            this.map.put(name, value);
            return;
        }
        if (!ex.getClass().equals(value.getClass())) {
            this.warnForDuplicate(name, ex);
            return;
        }
        if (ex.equals(value)) {
            return;
        }
        String existingVersion = NamedDescriptionElements.getFormatVersion(ex);
        String newVersion = NamedDescriptionElements.getFormatVersion(value);
        if (existingVersion == null) {
            if (newVersion != null) {
                this.map.put(name, value);
            } else {
                this.warnForDuplicate(name, value);
            }
        } else if (newVersion != null) {
            int cmp = Version.compareRulesFormatVersions(newVersion, existingVersion);
            if (cmp > 0) {
                this.map.put(name, value);
            } else if (cmp == 0) {
                this.warnForDuplicate(name, value);
            }
        }
    }

    private static String getFormatVersion(Object o) {
        if (o instanceof Description) {
            return ((Description)o).getFormatVersion();
        }
        if (o instanceof DescriptionTextElement) {
            return ((DescriptionTextElement)o).getFormatVersion();
        }
        return null;
    }

    private void warnForDuplicate(String name, Object o) {
        if (this.warnOnDuplicates) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 309, name, NamedDescriptionElements.typeof(o));
        }
    }

    private static String typeof(Object o) {
        XMLClassDescriptor cd;
        if (cdr == null) {
            cdr = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver((BindingType)BindingType.XML);
            cdr.setClassLoader(NamedDescriptionElements.class.getClassLoader());
            try {
                cdr.addPackage("com.fortify.io.rule");
            }
            catch (ResolverException e) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception initializing rule reader", (Throwable)e);
            }
        }
        try {
            cd = (XMLClassDescriptor)cdr.resolve(o.getClass());
        }
        catch (ResolverException e) {
            cd = null;
        }
        if (cd != null) {
            return cd.getXMLName();
        }
        String c = o.getClass().getName();
        return c.substring(c.lastIndexOf(46) + 1);
    }
}

