/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

public class NumberUtil {
    private static char[] NIBBLE_TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int[] floorLog2_LOOKUP_TABLE = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final int floorLog2_LOOKUP_TABLE_BITS = 8;
    private static final int floorLog2_LOOKUP_TABLE_SIZE = 256;

    private NumberUtil() {
    }

    public static String byteArrayToHexString(byte[] bytes) {
        char[] converted = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            converted[i * 2] = NIBBLE_TO_HEX[b >> 4 & 0xF];
            converted[i * 2 + 1] = NIBBLE_TO_HEX[b & 0xF];
        }
        return String.valueOf(converted);
    }

    public static byte[] intToByteArray(int i) {
        byte[] returnMe = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return returnMe;
    }

    public static String intToAlphabet(int x) {
        return x < 26 ? "" + (char)(65 + x) : NumberUtil.intToAlphabet(x / 26) + (char)(65 + x % 26);
    }

    public static long calcHash(byte[] buf, int start, int end) {
        long hash = 0L;
        for (int i = start; i < end; ++i) {
            long x = (hash = (hash << 4) + (long)buf[i]) & 0xF0000000L;
            if (x == 0L) continue;
            hash ^= x >> 24;
            hash &= x ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int setBit(int bitSet, int bitIndex, boolean b) {
        int bitMask = 1 << bitIndex;
        if (b) {
            return bitSet | bitMask;
        }
        return bitSet & ~bitMask;
    }

    public static boolean getBit(int bitSet, int bitIndex) {
        int bitMask = 1 << bitIndex;
        return (bitSet & bitMask) != 0;
    }

    public static int floorLog2(int i) {
        int bits = 16;
        int pos = 0;
        while (true) {
            int topSpan;
            if ((topSpan = i >>> bits) != 0) {
                i = topSpan;
                pos += bits;
            }
            if (i < 256) break;
            bits >>>= 1;
        }
        return pos += floorLog2_LOOKUP_TABLE[i];
    }

    public static int bitCount(int n) {
        int nBits = 0;
        while (n != 0) {
            ++nBits;
            n &= n - 1;
        }
        return nBits;
    }

    public static int bitCount(long n) {
        int nBits = 0;
        while (n != 0L) {
            ++nBits;
            n &= n - 1L;
        }
        return nBits;
    }

    public static boolean isPowerOfTwo(int n) {
        if (n == 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public static boolean isPowerOfTwo(long n) {
        if (n == 0L) {
            return false;
        }
        return (n & n - 1L) == 0L;
    }

    public static long getLong(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }

    public static double clamp(double min, double max, double v) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static int clamp(int min, int max, int v) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    static {
        if (floorLog2_LOOKUP_TABLE.length != 256) {
            throw new RuntimeException("Length = " + floorLog2_LOOKUP_TABLE.length + ", Bits = " + 8);
        }
    }
}

