/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.Util;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class Pair<A, B>
implements Serializable {
    public final A first;
    public final B second;
    private static final Pair<Object, Object> NullPair = new Pair<Object, Object>(null, null);

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public Pair(Map.Entry<? extends A, ? extends B> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public static <A, B> Pair<A, B> mk(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public static <A, B> Pair<A, B> nullPair() {
        return NullPair;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pair)) {
            return false;
        }
        return this.equals((Pair)other);
    }

    public boolean equals(Pair<A, B> other) {
        return Util.eq(this.first, other.first) && Util.eq(this.second, other.second);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.first != null) {
            hashCode ^= this.first.hashCode();
        }
        if (this.second != null) {
            hashCode ^= this.second.hashCode();
        }
        return hashCode;
    }

    public static <A, B> Iterator<A> firstIterator(final Iterator<Pair<A, B>> it) {
        return new Iterator<A>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public A next() {
                return ((Pair)it.next()).first;
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static <A, B> Iterator<B> secondIterator(final Iterator<Pair<A, B>> it) {
        return new Iterator<B>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public B next() {
                return ((Pair)it.next()).second;
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }
}

