/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.system.Version;
import com.fortify.util.Func;
import com.fortify.util.Pair;
import com.fortify.util.StringBuilderWriter;
import com.fortify.util.SystemUtil;
import com.fortify.util.VmMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PropertiesRenderer {
    private PropertiesRenderer() {
    }

    public static String renderProperties(Version.Product product, List<Pair<String, Properties>> toLog, Func<String, Boolean> filter) {
        return SystemUtil.LINE_SEP + "Version:" + Version.getVersionString(product) + SystemUtil.LINE_SEP + PropertiesRenderer.renderProperties(toLog, filter);
    }

    public static String renderProperties(List<Pair<String, Properties>> toLog, Func<String, Boolean> filter) {
        StringBuilder propertyDump = new StringBuilder();
        propertyDump.append("------------------------- Runtime Information -------------------------------").append(SystemUtil.LINE_SEP);
        Iterator<Pair<String, Properties>> it = toLog.iterator();
        while (it.hasNext()) {
            Pair<String, Properties> pair = it.next();
            String name = (String)pair.first;
            Properties properties = (Properties)pair.second;
            propertyDump.append(name).append(SystemUtil.LINE_SEP);
            ArrayList<Object> propKeys = new ArrayList<Object>(properties.keySet());
            Collections.sort(propKeys);
            for (String string : propKeys) {
                if (filter != null && filter.apply(string) == Boolean.TRUE) continue;
                String v = properties.getProperty(string);
                propertyDump.append(string).append('=').append(v).append(SystemUtil.LINE_SEP);
            }
            if (!it.hasNext()) continue;
            propertyDump.append(SystemUtil.LINE_SEP);
        }
        propertyDump.append(SystemUtil.LINE_SEP).append("VM Info").append(SystemUtil.LINE_SEP);
        VmMonitor.printMXBeans(EnumSet.of(VmMonitor.MXBeanType.OperatingSystem, VmMonitor.MXBeanType.Runtime), new StringBuilderWriter(propertyDump));
        propertyDump.append("-----------------------------------------------------------------------------");
        return propertyDump.toString();
    }
}

