/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.ArrayUtil;
import com.fortify.util.ByteArrayBuilder;
import com.fortify.util.StringUtil;
import java.util.ArrayList;

public class ReallySimpleEncoding {
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private ReallySimpleEncoding() {
    }

    public static byte[][] decodeArray(byte[] s) throws DecodeException {
        if (s.length == 0) {
            return new byte[0][];
        }
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        ByteArrayBuilder buf = new ByteArrayBuilder();
        int i = 0;
        while (i < s.length) {
            buf.clear();
            i = ReallySimpleEncoding.decodeArrayElement(buf, s, i);
            args.add(buf.getCopy());
        }
        return (byte[][])args.toArray((T[])new byte[args.size()][]);
    }

    public static int decodeArrayElement(ByteArrayBuilder buf, byte[] s, int i) throws DecodeException {
        byte c;
        while ((c = s[i]) != 124) {
            if (c == 38) {
                if (i + 3 > s.length) {
                    throw new DecodeException("incomplete escape sequence", s, i);
                }
                int h1 = ArrayUtil.indexOf(HEX, s[i + 1]);
                int h2 = ArrayUtil.indexOf(HEX, s[i + 2]);
                if (h1 < 0 || h2 < 0) {
                    throw new DecodeException("invalid hex digit in escape sequence", s, i);
                }
                byte d = (byte)(h1 << 4 | h2);
                buf.append(d);
                i += 3;
            } else if (c >= 32 && c <= 126) {
                buf.append(c);
                ++i;
            } else {
                throw new DecodeException("invalid character", s, i);
            }
            if (i < s.length) continue;
            throw new DecodeException("missing RSE end mark", s, i);
        }
        return ++i;
    }

    public static byte[] encodeArray(byte[][] s) {
        ByteArrayBuilder buf = new ByteArrayBuilder();
        for (int i = 0; i < s.length; ++i) {
            ReallySimpleEncoding.encodeArrayElement(buf, s[i]);
        }
        return buf.getCopy();
    }

    public static void encodeArrayElement(ByteArrayBuilder buf, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte c = bytes[i];
            if (c < 32 || c > 126 || c == 124 || c == 38) {
                buf.append((byte)38);
                buf.append(HEX[c >>> 4 & 0xF]);
                buf.append(HEX[c & 0xF]);
                continue;
            }
            buf.append(c);
        }
        buf.append((byte)124);
    }

    static {
        assert (HEX.length == 16);
    }

    public static class DecodeException
    extends Exception {
        public final int position;
        public final byte[] input;

        public DecodeException(String message, byte[] input, int position) {
            super(message);
            this.input = input;
            this.position = position;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + ": " + StringUtil.toJavaAsciiLiteral(this.input) + " at position " + this.position;
        }
    }
}

