/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.exceptions.FortifyException;
import com.fortify.messaging.Message;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static Method getPublicStaticMethod(String fullyQualifiedMethodName, Class[] args, ClassLoader cl) throws FortifyException, ClassNotFoundException, NoSuchMethodException {
        String methodName;
        int spot = fullyQualifiedMethodName.lastIndexOf(46);
        if (spot == -1) {
            throw new FortifyException(new Message(4, 201, fullyQualifiedMethodName));
        }
        String className = fullyQualifiedMethodName.substring(0, spot);
        Class<?> c = cl == null ? Class.forName(className) : Class.forName(className, true, cl);
        Method method = c.getMethod(methodName = fullyQualifiedMethodName.substring(spot + 1), args);
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new FortifyException(new Message(4, 202, fullyQualifiedMethodName));
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new FortifyException(new Message(4, 203, fullyQualifiedMethodName));
        }
        return method;
    }

    public static Method getPublicStaticMethod(String fullyQualifiedMethodName, Class[] args) throws FortifyException, ClassNotFoundException, NoSuchMethodException {
        return ReflectionUtil.getPublicStaticMethod(fullyQualifiedMethodName, args, null);
    }

    public static boolean classImplementsInterface(Class clss, Class interfce) {
        Class<?>[] interfaces = clss.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface != interfce) continue;
            return true;
        }
        return false;
    }
}

