/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.io.rule.Abstract;
import com.fortify.io.rule.Description;
import com.fortify.io.rule.DescriptionTextElement;
import com.fortify.io.rule.Descriptions;
import com.fortify.io.rule.Explanation;
import com.fortify.io.rule.Recommendations;
import com.fortify.io.rule.Reference;
import com.fortify.io.rule.References;
import com.fortify.io.rule.Tip;
import com.fortify.io.rule.Tips;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.NamedDescriptionElements;

public class RuleUtil {
    static ILogger logger = MessageManager.getLogger(RuleUtil.class);
    public static final String DESC_ELEMENT_SEP = System.getProperty("line.separator");

    private RuleUtil() {
    }

    public static NamedDescriptionElements buildDescriptionElementMap(Descriptions descriptionsElement, boolean warnOnDuplicates) {
        References[] refss;
        Tips[] tipss;
        Description[] dscs;
        Recommendations[] recs;
        Explanation[] expn;
        Abstract[] abst;
        NamedDescriptionElements result = new NamedDescriptionElements(warnOnDuplicates);
        if (descriptionsElement == null) {
            return result;
        }
        for (Abstract descNode : abst = descriptionsElement.getAbstract()) {
            RuleUtil.putDescNode(result, descNode);
        }
        for (Explanation descNode : expn = descriptionsElement.getExplanation()) {
            RuleUtil.putDescNode(result, descNode);
        }
        for (Recommendations descNode : recs = descriptionsElement.getRecommendations()) {
            RuleUtil.putDescNode(result, descNode);
        }
        for (Description descNode : dscs = descriptionsElement.getDescription()) {
            result.put(descNode);
        }
        for (Tips tipsNode : tipss = descriptionsElement.getTips()) {
            if (tipsNode.getId() != null) {
                result.put(tipsNode);
            }
            Tip[] tips = tipsNode.getTip();
            for (int j = 0; j < tipsNode.getTipCount(); ++j) {
                Tip tip = tips[j];
                if (tip.getId() == null) continue;
                RuleUtil.putDescNode(result, tip);
            }
        }
        for (References refsNode : refss = descriptionsElement.getReferences()) {
            Reference[] refs;
            if (refsNode.getId() != null) {
                result.put(refsNode);
            }
            for (Reference ref : refs = refsNode.getReference()) {
                if (ref.getId() == null) continue;
                result.put(ref);
            }
        }
        return result;
    }

    private static void putDescNode(NamedDescriptionElements map, DescriptionTextElement node) {
        map.put(node);
    }

    public static Description populateDescription(NamedDescriptionElements namedDescriptionElements, Description desc, String containerFormatVersion) {
        String abst;
        Description result = null;
        if (desc.getRef() != null) {
            Description d = (Description)namedDescriptionElements.get(desc.getRef());
            if (d == null) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, 210, desc.getRef());
            } else {
                result = RuleUtil.populateDescription(namedDescriptionElements, d, null);
            }
        } else if (desc.getFormatVersion() == null) {
            desc.setFormatVersion(containerFormatVersion);
        }
        if (result == null) {
            result = new Description();
            result.setFormatVersion(desc.getFormatVersion());
        }
        if (result.getAbstract() == null) {
            result.setAbstract(new Abstract());
        }
        if (result.getRecommendations() == null) {
            result.setRecommendations(new Recommendations());
        }
        if (result.getExplanation() == null) {
            result.setExplanation(new Explanation());
        }
        if (result.getTips() == null) {
            result.setTips(new Tips());
        }
        if (result.getReferences() == null) {
            result.setReferences(new References());
        }
        if (result.getAbstract().getFormatVersion() == null) {
            result.getAbstract().setFormatVersion(result.getFormatVersion());
        }
        if (result.getExplanation().getFormatVersion() == null) {
            result.getExplanation().setFormatVersion(result.getFormatVersion());
        }
        if (result.getRecommendations().getFormatVersion() == null) {
            result.getRecommendations().setFormatVersion(result.getFormatVersion());
        }
        if ((abst = RuleUtil.mergeTextElements(result.getAbstract(), desc.getAbstract(), namedDescriptionElements)) == null || abst.length() == 0) {
            result.setAbstract(null);
        } else {
            result.getAbstract().setContent(abst);
        }
        String explan = RuleUtil.mergeTextElements(result.getExplanation(), desc.getExplanation(), namedDescriptionElements);
        if (explan == null || explan.length() == 0) {
            result.setExplanation(null);
        } else {
            result.getExplanation().setContent(explan);
        }
        String recs = RuleUtil.mergeTextElements(result.getRecommendations(), desc.getRecommendations(), namedDescriptionElements);
        if (recs == null || recs.length() == 0) {
            result.setRecommendations(null);
        } else {
            result.getRecommendations().setContent(recs);
        }
        Tips tips = desc.getTips();
        Tips resultTips = result.getTips();
        if (tips != null) {
            if (tips.getRef() != null) {
                Tips refedTips = (Tips)namedDescriptionElements.get(tips.getRef());
                if (refedTips == null) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, 210, tips.getRef());
                } else {
                    for (int i = 0; i < refedTips.getTipCount(); ++i) {
                        resultTips.addTip(refedTips.getTip(i));
                    }
                }
            }
            for (int i = 0; i < tips.getTipCount(); ++i) {
                Tip tip = tips.getTip(i);
                if (tip.getRef() != null) {
                    Tip t = (Tip)namedDescriptionElements.get(tip.getRef());
                    if (t == null) {
                        logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, 210, tip.getRef());
                        continue;
                    }
                    resultTips.addTip(t);
                    continue;
                }
                resultTips.addTip(tip);
            }
        }
        if (resultTips.getTipCount() == 0) {
            result.setTips(null);
        }
        References refs = desc.getReferences();
        References resultRefs = result.getReferences();
        if (refs != null) {
            if (refs.getRef() != null) {
                References refedRefs = (References)namedDescriptionElements.get(refs.getRef());
                if (refedRefs == null) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, 210, refs.getRef());
                } else {
                    for (int i = 0; i < refedRefs.getReferenceCount(); ++i) {
                        Reference ref = refedRefs.getReference(i);
                        resultRefs.addReference(ref);
                    }
                }
            }
            for (int i = 0; i < refs.getReferenceCount(); ++i) {
                Reference ref = refs.getReference(i);
                if (ref.getRef() != null) {
                    Reference r = (Reference)namedDescriptionElements.get(ref.getRef());
                    if (r == null) {
                        logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, 210, ref.getRef());
                        continue;
                    }
                    resultRefs.addReference(r);
                    continue;
                }
                resultRefs.addReference(ref);
            }
        }
        if (resultRefs.getReferenceCount() == 0) {
            result.setReferences(null);
        }
        if (result.getAbstract() == null && result.getExplanation() == null && result.getRecommendations() == null && result.getReferences() == null && result.getTips() == null) {
            result = null;
        }
        return result;
    }

    private static String mergeTextElements(DescriptionTextElement outer, DescriptionTextElement inner, NamedDescriptionElements namedDescriptionElements) {
        String result = outer.getContent();
        if (inner != null) {
            String secondRef = null;
            if (inner.getRef() != null) {
                DescriptionTextElement e = (DescriptionTextElement)namedDescriptionElements.get(inner.getRef());
                if (e == null) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, 210, inner.getRef());
                } else {
                    secondRef = e.getContent();
                }
            }
            result = RuleUtil.synthDescString(inner.getAppend() ? outer.getContent() : null, secondRef, inner.getContent());
        }
        return result;
    }

    private static String synthDescString(String primaryRef, String secondaryRef, String content) {
        StringBuilder result = new StringBuilder();
        boolean hasContent = false;
        if (primaryRef != null && primaryRef.length() > 0) {
            result.append(primaryRef);
            hasContent = true;
        }
        if (secondaryRef != null && secondaryRef.length() > 0) {
            if (hasContent) {
                result.append(DESC_ELEMENT_SEP);
            }
            result.append(secondaryRef);
            hasContent = true;
        }
        if (content != null && content.length() > 0) {
            if (hasContent) {
                result.append(DESC_ELEMENT_SEP);
            }
            result.append(content);
            hasContent = true;
        }
        return hasContent ? result.toString() : null;
    }
}

