/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.FileUtil;
import com.fortify.util.StringUtil;
import java.io.File;
import java.io.FileFilter;

public class RulepackUtil {
    public static final String[] RULEPACK_EXTENSIONS = new String[]{".bin", ".xml", ".rpr"};
    public static final String[] NON_RULEPACK_FILENAMES = new String[]{"projecttemplate.xml", "defaulttemplate.xml"};

    public static boolean isRulepack(String path) {
        if (StringUtil.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return RulepackUtil.isRulepack(file);
    }

    public static boolean isRulepack(File file) {
        if (!FileUtil.isExistingFile(file)) {
            return false;
        }
        String filename = file.getName();
        for (String nonRulepackFilename : NON_RULEPACK_FILENAMES) {
            if (!nonRulepackFilename.equals(filename)) continue;
            return false;
        }
        for (String suffix : RULEPACK_EXTENSIONS) {
            if (!filename.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static File[] getRulepacks(File rulepackDir) {
        if (!FileUtil.isExistingDirectory(rulepackDir)) {
            return null;
        }
        File[] files = rulepackDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return RulepackUtil.isRulepack(file);
            }
        });
        if (files == null) {
            return null;
        }
        return files;
    }

    public static String[] getRulepackFilter() {
        int numRulepacks = RULEPACK_EXTENSIONS.length;
        String[] filter = new String[numRulepacks];
        for (int i = 0; i < numRulepacks; ++i) {
            filter[i] = "*" + RULEPACK_EXTENSIONS[i];
        }
        return filter;
    }
}

