/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.configuration.SCAConfigurationUtil;
import com.fortify.licensing.Capability;
import com.fortify.licensing.LicenseException;
import com.fortify.licensing.UnlicensedCapabilityException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Localization;
import com.fortify.messaging.MessageManager;
import com.fortify.system.InputEater;
import com.fortify.system.InputListener;
import com.fortify.system.Version;
import com.fortify.util.CollectionUtil;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.FileUtil;
import com.fortify.util.InstallationConfiguration;
import com.fortify.util.SCARunner.AdvancedSCAExec;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.ScanSpecification;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import com.fortify.util.SCARunner.specification.commands.CleanupManagedLicenseCommand;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import com.fortify.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public abstract class AbstractSCAExec
implements Runnable {
    private static ILogger logger = MessageManager.getLogger(AbstractSCAExec.class);
    private boolean finished = false;
    private boolean interrupted = false;
    private Process p;
    private int returnCode = 0;
    private ArrayList<String> errorList = new ArrayList();
    private boolean canceled = false;
    private FortifyProgressMonitor monitor;
    private static final String ARGUMENT_FILE_EXT = ".txt";
    private static final String TRANSLATION_STRING = Localization.getLocalString(261, new Object[0]);
    private static final String SCAN_STRING = Localization.getLocalString(262, new Object[0]);
    private static final String OPT_SQL = "-Dcom.fortify.sca.fileextensions.sql=";
    public static final String OPT_QUICK_SCAN = "-Dcom.fortify.sca.QuickScanMode=true";
    public static final String PID = "-pid-file";
    private static final String OPT_XMX = "-Xmx";
    private File PIDFile;
    public static final String DEFAULT_STACK_SIZE = "-Xss16M";
    public static final String DEFAULT_MAX_HEAP = "-Xmx1800M";
    public static final String DEFAULT_MIN_HEAP = "-Xms300M";
    private static final Capability DEVINSPECT_CAPABILITY = new Capability("DevInspect", "DevInspect Eclipse Plug-in");
    protected final SmartScanSpecification scanSpec;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public AbstractSCAExec(SmartScanSpecification spec) {
        this.scanSpec = spec;
    }

    void setStarted() {
        this.finished = false;
    }

    void setFinished() {
        this.finished = true;
    }

    public boolean finished() {
        return this.finished;
    }

    private void setInterrupted() {
        this.interrupted = true;
    }

    public boolean interrupted() {
        return this.interrupted;
    }

    public void interrupt() {
        if (this.p != null) {
            try {
                this.p.getOutputStream().close();
            }
            catch (IOException e) {
                this.scanSpec.setException(e);
            }
        } else {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Sourceanalyzer process has not been started. No stream to close");
        }
        this.canceled = true;
        if (SystemUtil.isWindows()) {
            if (this.PIDFile != null) {
                KillThread kt = new KillThread(this.PIDFile.getAbsolutePath());
                kt.start();
            } else {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "PID File doesn't exist. No thread to close.");
            }
        } else if (this.p != null) {
            this.p.destroy();
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Called Process.destroy() on sourceanalyer process");
        } else {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Sourceanalyzer process has not been started. No process to destroy.");
        }
    }

    public boolean canceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeArgFile(File argFile, boolean captureOutput, List<String> launcherArgs, boolean needsMemory) throws IOException {
        ArrayList<String> buffer;
        String line;
        ArrayList<String> mutableLauncherArgs;
        String sqlType;
        String memory;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> javaArgs = new ArrayList<String>(2);
        String scaExecutable = this.scanSpec.getExecutable();
        if (needsMemory && !StringUtil.isEmpty(memory = this.scanSpec.getMemory())) {
            javaArgs.add(OPT_XMX + memory + 'M');
        }
        if (!StringUtil.isEmpty(sqlType = this.scanSpec.getSQLType())) {
            javaArgs.add(OPT_SQL + sqlType);
        }
        if (this.scanSpec.isQuickScanEnabled()) {
            javaArgs.add(OPT_QUICK_SCAN);
        }
        boolean useDefaultMaxHeapSize = true;
        boolean useDefaultMinHeapSize = true;
        boolean useDefaultStackSize = true;
        StringBuffer scaJvmArgsFlagValue = new StringBuffer();
        if (launcherArgs != null) {
            mutableLauncherArgs = new ArrayList(launcherArgs.size());
            for (String arg : launcherArgs) {
                if (arg.startsWith("-X")) {
                    javaArgs.add(arg);
                    scaJvmArgsFlagValue.append(arg);
                    scaJvmArgsFlagValue.append(' ');
                    if (arg.startsWith(OPT_XMX)) {
                        useDefaultMaxHeapSize = false;
                        continue;
                    }
                    if (arg.startsWith("-Xms")) {
                        useDefaultMinHeapSize = false;
                        continue;
                    }
                    if (!arg.startsWith("-Xss")) continue;
                    useDefaultStackSize = false;
                    continue;
                }
                mutableLauncherArgs.add(arg);
            }
        } else {
            mutableLauncherArgs = new ArrayList<String>(0);
        }
        if (SCAConfigurationUtil.isDevInspect(scaExecutable)) {
            String fortifyHome;
            String installRoot;
            String win32key;
            String win32LocalAppdata;
            String java = SCAConfigurationUtil.getJavaExecPath();
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "java:" + java);
            if (FileUtil.isExistingFile(java)) {
                args.add(java);
            } else {
                args.add("java");
            }
            if (useDefaultMaxHeapSize) {
                args.add(DEFAULT_MAX_HEAP);
                scaJvmArgsFlagValue.append(DEFAULT_MAX_HEAP);
                scaJvmArgsFlagValue.append(' ');
            }
            if (useDefaultMinHeapSize) {
                args.add(DEFAULT_MIN_HEAP);
                scaJvmArgsFlagValue.append(DEFAULT_MIN_HEAP);
                scaJvmArgsFlagValue.append(' ');
            }
            if (useDefaultStackSize) {
                args.add(DEFAULT_STACK_SIZE);
                scaJvmArgsFlagValue.append(DEFAULT_STACK_SIZE);
                scaJvmArgsFlagValue.append(' ');
            }
            if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DEBUG_LAUNCHED_UTILITIES)) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
            }
            if (!SystemUtil.isAIX()) {
                args.add("-XX:SoftRefLRUPolicyMSPerMB=3000");
            }
            if (SystemUtil.isSolaris() || SystemUtil.isMacos() || SystemUtil.isHPUX()) {
                args.add("-d64");
            }
            if (!SystemUtil.isMacos()) {
                args.add("-Dcom.sun.management.jmxremote=true");
            }
            args.add("-Djava.awt.headless=true");
            args.add("-jar");
            args.add(scaExecutable);
            try {
                String[] tokens = AbstractSCAExec.generateDevinspectTokens(new Date[]{new Date()}, DEVINSPECT_CAPABILITY);
                if (tokens == null || StringUtil.isEmpty(tokens[0])) {
                    throw new UnlicensedCapabilityException(DEVINSPECT_CAPABILITY);
                }
                args.add("-Ddevinspect=" + tokens[0]);
            }
            catch (LicenseException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            if (scaJvmArgsFlagValue.length() > 0) {
                args.add("-Dcom.fortify.sca.JVMArgs=" + scaJvmArgsFlagValue.toString());
            }
            if (SystemUtil.isWindows() && !FileUtil.isExistingDirectory(win32LocalAppdata = System.getProperty(win32key = "win32.LocalAppdata"))) {
                args.add("-D" + win32key + '=' + win32LocalAppdata);
            }
            if (!StringUtil.isEmpty(installRoot = SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT))) {
                args.add("-D" + CommonPropertyKeys.PK_FORTIFY_INST_ROOT.key + '=' + installRoot);
            }
            if (!StringUtil.isEmpty(fortifyHome = SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_WORKDIR))) {
                args.add("-D" + CommonPropertyKeys.PK_FORTIFY_WORKDIR.key + '=' + fortifyHome);
                args.add("-Dcom.fortify.sca.ProjectRoot=" + fortifyHome);
                String di = "DevInspect-" + Version.getMajorMinorPatchVersion(Version.getVersion(Version.Product.DEVINSPECT));
                args.add("-Dcom.fortify.sca.LogFile=" + InstallationConfiguration.getProductLogDirectory(di) + File.separator + "static.assessment.log");
            }
        } else {
            args.add(scaExecutable);
        }
        args.addAll(javaArgs);
        args.addAll(mutableLauncherArgs);
        if (SystemUtil.isWindows()) {
            this.PIDFile = File.createTempFile("PID", ".tmp");
            this.PIDFile.deleteOnExit();
            args.add(PID);
            args.add(this.PIDFile.getAbsolutePath());
        }
        args.add('@' + argFile.getAbsolutePath());
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Scan Command:" + args.toString());
        this.p = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        InputListener monitorUpdate = !captureOutput && this.monitor != null ? new UpdatingInputListener() : new OutputCapturingListener();
        InputEater errorEater = new InputEater(this.p.getErrorStream());
        errorEater.start();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        try {
            while ((line = stdout.readLine()) != null) {
                monitorUpdate.processInput(line);
            }
        }
        finally {
            FileUtil.close(stdout);
        }
        try {
            this.p.waitFor();
            errorEater.join();
            this.returnCode = this.p.exitValue();
            this.scanSpec.setReturnCode(this.returnCode);
        }
        catch (InterruptedException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "InterruptedException in SCAExec", (Throwable)e);
            this.scanSpec.setException(e);
            this.setInterrupted();
        }
        BufferedReader stderr = new BufferedReader(new StringReader(errorEater.getOutput()));
        while ((line = stderr.readLine()) != null) {
            if (line.length() <= 0) continue;
            this.scanSpec.addError(line);
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, line);
        }
        if (this.checkError() && !CollectionUtil.isEmpty(buffer = monitorUpdate.getBuffer())) {
            for (String s : buffer) {
                this.scanSpec.addError(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File generateArgFile(String args, String argFilePrefix) {
        File file;
        block5: {
            file = null;
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            BufferedWriter writer = null;
            try {
                file = this.getArgumentFile(argFilePrefix);
                fos = new FileOutputStream(file);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                writer = new BufferedWriter(osw);
                byte[] bom = new byte[]{-17, -69, -65};
                String unicode_BOM = new String(bom, "UTF-8");
                ((Writer)writer).write(unicode_BOM, 0, unicode_BOM.length());
                StringBuffer buf = new StringBuffer();
                ((Writer)writer).write(args, 0, args.length());
                buf.append(args);
                ((Writer)writer).close();
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "SCA Argument : " + buf.toString());
                FileUtil.close(writer);
            }
            catch (IOException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error generating arg file", (Throwable)e);
                break block5;
            }
            finally {
                FileUtil.close(writer);
                FileUtil.close(osw);
                FileUtil.closeAgain(fos);
            }
            FileUtil.close(osw);
            FileUtil.closeAgain(fos);
        }
        return file;
    }

    private File getArgumentFile(String argFilePrefix) {
        File file;
        String buildId = this.scanSpec.getBuildId();
        try {
            if (this.scanSpec.getArgFilePath() != null) {
                file = new File(this.scanSpec.getArgFilePath() + File.separator + buildId + argFilePrefix + ARGUMENT_FILE_EXT);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
            } else {
                file = new File(InstallationConfiguration.getProjectWorkingDirectory(buildId) + File.separator + buildId + argFilePrefix + ARGUMENT_FILE_EXT);
            }
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error creating argument file", (Throwable)e);
            String uncreatable = "Uncreatable";
            file = new File(InstallationConfiguration.getProjectWorkingDirectory(uncreatable) + File.separator + uncreatable + argFilePrefix + ARGUMENT_FILE_EXT);
        }
        return file;
    }

    public boolean checkError() {
        return this.returnCode != 0;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public ArrayList<String> getErrorList() {
        return this.errorList;
    }

    public void setMonitor(FortifyProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public FortifyProgressMonitor getMonitor() {
        return this.monitor;
    }

    public static String[] generateDevinspectTokens(Date[] dates, Capability capability) throws LicenseException {
        MessageDigest md;
        String preimage = "salt:";
        try {
            preimage = preimage + SystemUtil.getHostName() + '#';
        }
        catch (UnknownHostException e) {
            throw new UnlicensedCapabilityException(capability);
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new UnlicensedCapabilityException(capability);
        }
        SimpleDateFormat format = new SimpleDateFormat("hh-mm-yyyy-MM-dd");
        String[] tokens = new String[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            String test = preimage + format.format(dates[i]);
            md.reset();
            md.update(test.getBytes());
            tokens[i] = AbstractSCAExec.bytesToHex(md.digest());
        }
        return tokens;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    protected void runCleanupManagedLicense() {
        try {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Run managed license cleanup");
            if (this.monitor != null) {
                this.monitor.subTask("Finishing SCA execution...");
            }
            CleanupManagedLicenseCommand cleanupCommand = new CleanupManagedLicenseCommand();
            AdvancedSCAExec exec = new AdvancedSCAExec(new ScanSpecification(this.scanSpec.getExecutable()));
            exec.executeArgFile(this.generateArgFile(cleanupCommand.buildCommandLine(), cleanupCommand.getArgFilePrefix()), cleanupCommand.shouldCaptureOutput(), cleanupCommand.getLauncherArgs(), cleanupCommand.needsMemory());
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.LOG, "Managed licene cleanup failed with exception", (Throwable)e);
        }
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String a, String b) {
            return Util.compare(a, b, 1);
        }
    }

    private class OutputCapturingListener
    implements InputListener {
        private OutputCapturingListener() {
        }

        @Override
        public void processInput(String msg) {
            AbstractSCAExec.this.scanSpec.addOutputLine(msg);
        }

        @Override
        public ArrayList<String> getBuffer() {
            return null;
        }
    }

    private class UpdatingInputListener
    implements InputListener {
        int previousWork = 0;
        private ArrayList<String> buffer = new ArrayList();

        private UpdatingInputListener() {
        }

        @Override
        public void processInput(String msg) {
            try {
                if (msg.length() > 0) {
                    int i = msg.indexOf(124);
                    if (i == -1) {
                        AbstractSCAExec.this.monitor.subTask(TRANSLATION_STRING + msg);
                        AbstractSCAExec.this.monitor.worked(1);
                        if (msg.indexOf(".java") == -1) {
                            this.buffer.add(msg);
                        }
                        return;
                    }
                    String worked = msg.substring(0, i);
                    int update = Integer.parseInt(worked) - this.previousWork;
                    this.previousWork = Integer.parseInt(worked);
                    if (this.previousWork != -1) {
                        AbstractSCAExec.this.monitor.worked(update);
                    }
                    String phase = msg.substring(i + 1);
                    phase = phase.replace('|', ' ');
                    AbstractSCAExec.this.monitor.subTask(SCAN_STRING + phase);
                }
            }
            catch (Exception e) {
                AbstractSCAExec.this.monitor.subTask(msg);
                logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Error processing input from SCAExec", (Throwable)e);
            }
        }

        @Override
        public ArrayList<String> getBuffer() {
            return this.buffer;
        }
    }

    private static class KillThread
    extends Thread {
        String PID;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KillThread(String PIDFile) {
            BufferedReader bi = null;
            try {
                FileReader in = new FileReader(PIDFile);
                bi = new BufferedReader(in);
                this.PID = bi.readLine();
                bi.close();
            }
            catch (IOException e) {
                try {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error Killing Process", (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(bi);
                    throw throwable;
                }
                FileUtil.close(bi);
            }
            FileUtil.close(bi);
        }

        @Override
        public void run() {
            try {
                int pid = Integer.parseInt(this.PID);
                String[] cmd = new String[]{"taskkill", "/pid", Integer.toString(pid), "/t", "/F"};
                Process treeKill = Runtime.getRuntime().exec(cmd);
                treeKill.waitFor();
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Called taskkill on sourceanalyer process");
            }
            catch (InterruptedException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Process TreeKill was interrupted", (Throwable)e);
            }
            catch (IOException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error Killing process", (Throwable)e);
            }
            catch (NumberFormatException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error Killing process, the PID isn't a number.");
            }
        }
    }
}

