/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.configuration.SCAConfigurationUtil;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.SCAArgument;
import com.fortify.util.StringUtil;
import com.fortify.util.WindowsArgProtector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractScanSpecification {
    protected ILogger logger = MessageManager.getLogger(this.getClass());
    static ILogger slogger = MessageManager.getLogger(AbstractScanSpecification.class);
    public static final String SCA_EXECUTABLE = SCAConfigurationUtil.getSCAPath();
    public static List<String> LAUNCHER_ARG_PREFIXES = Arrays.asList("-flaunch_", "-autoheap", "-64", "-X", "-VM:", "-scan");
    public static final String CLASSPATH_FLAG = "-cp";
    public static final String REFERENCE_FLAG = "-libdirs";
    public static final String FILE_FLAG = "-f";
    public static final String OPT_CLEAN = "-clean";
    public static final String OPT_BUILDID = "-b";
    public static final String OPT_SCAN = "-scan";
    public static final String OPT_MACHOUT = "-machine-output";
    public static final String OPT_DEBUG = "-debug";
    public static final String ANALYZERS_FLAG = "-analyzer";
    public static final String SOURCE_FLAG = "-source";
    public static final String BUILD_DIR_FLAG = "-java-build-dir";
    public static final String FINDBUGS_FLAG = "-findbugs";
    public static final String NO_DEFAULT_RULES = "-no-default-rules";
    public static final String RULES_FLAG = "-rules";
    public static final String OPT_EXCLUDE = "-exclude";
    public static final String SOURCE_PATH_FLAG = "-sourcepath";
    private static Set<String> multiFlags = new HashSet<String>();
    private String buildId;
    private boolean debugging;
    private String exectuable;
    private String argPathFile = null;
    private String memory;
    private List<String> errorList = new ArrayList<String>();
    private Exception exception;
    private String specName;
    private String sqlType;
    private boolean quickScanEnabled;
    private boolean machineOut = true;
    private List<String> outputLines = new ArrayList<String>();
    private int returnCode = 0;
    private boolean cancelled = false;

    public AbstractScanSpecification(String executable) {
        this.exectuable = executable;
    }

    public abstract AbstractSCAExec createExec();

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean failed() {
        return this.exception != null || this.returnCode != 0;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasErrors() {
        return !this.errorList.isEmpty();
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public void setExectuable(String exectuable) {
        this.exectuable = exectuable;
    }

    public void setArgPathFile(String argPathFile) {
        this.argPathFile = argPathFile;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public String getExecutable() {
        return this.exectuable;
    }

    @Deprecated
    public void addErrors(ArrayList<String> errorList) {
        this.errorList = errorList;
    }

    public void setErrors(ArrayList<String> errorList) {
        this.errorList = errorList;
    }

    public String getArgFilePath() {
        return this.argPathFile;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setQuickScanEnabled(boolean quickScanEnabled) {
        this.quickScanEnabled = quickScanEnabled;
    }

    public boolean isQuickScanEnabled() {
        return this.quickScanEnabled;
    }

    public void setException(Exception e) {
        this.logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error in SCA Execution", (Throwable)e);
        this.exception = e;
    }

    public void addError(String msg) {
        this.errorList.add(msg);
    }

    public void setSpecName(String specName) {
        this.specName = specName;
    }

    public String getSpecificationName() {
        return this.specName;
    }

    public void setSQLType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void addOutputLine(String msg) {
        this.outputLines.add(msg);
    }

    public List<String> getOutput() {
        return this.outputLines;
    }

    static void appendArgumentsToCommand(List<String> cmd, List<? extends SCAArgument> scaArguments) {
        for (SCAArgument sCAArgument : scaArguments) {
            sCAArgument.addToCommand(cmd);
        }
    }

    static String printArgs(List<String> args, String additionalArgs) {
        StringBuilder buf = new StringBuilder();
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            buf.append(WindowsArgProtector.quote(s));
            if (!iterator.hasNext()) continue;
            buf.append("\n");
        }
        if (additionalArgs != null) {
            if (buf.length() != 0) {
                buf.append("\n");
            }
            buf.append(additionalArgs).append("\n");
        }
        return buf.toString();
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    static Object[] extractLauncherArgs(String text) {
        String[] parsed = StringUtil.parseArguments(text);
        ArrayList<String> launcher = new ArrayList<String>();
        ArrayList<String> validArgs = new ArrayList<String>();
        for (String arg : parsed) {
            boolean isLaunch = false;
            for (String prefix : LAUNCHER_ARG_PREFIXES) {
                if (!arg.startsWith(prefix)) continue;
                launcher.add(arg);
                isLaunch = true;
            }
            if (!isLaunch) {
                slogger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Identified non-launcher argument: " + arg);
                validArgs.add(arg);
                continue;
            }
            slogger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Identified launcher argument: " + arg);
        }
        Object[] launcherRegular = new Object[]{launcher.isEmpty() ? null : launcher, AbstractScanSpecification.printArgs(validArgs, null)};
        return launcherRegular;
    }

    public void setCancelled(boolean b) {
        this.cancelled = b;
    }

    public static Set<String> getMultiFlags() {
        return multiFlags;
    }

    public void setMachineOut(boolean machineOut) {
        this.machineOut = machineOut;
    }

    public boolean getMachineOut() {
        return this.machineOut;
    }

    static {
        multiFlags.add(RULES_FLAG);
    }
}

