/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import com.fortify.util.SCARunner.specification.commands.ExecCommand;
import java.util.List;

public class AdvancedSCAExec
extends AbstractSCAExec {
    private static ILogger logger = MessageManager.getLogger(AdvancedSCAExec.class);

    public AdvancedSCAExec(SmartScanSpecification spec) {
        super(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<? extends ExecCommand> runCommands = this.scanSpec.getCommands();
        FortifyProgressMonitor monitor = this.getMonitor();
        try {
            this.setStarted();
            if (monitor != null) {
                monitor.beginTask(this.scanSpec.getSpecificationName(), runCommands.size());
            }
            for (ExecCommand execCommand : runCommands) {
                if (this.canceled()) {
                    this.scanSpec.setCancelled(true);
                    break;
                }
                if (this.interrupted()) break;
                if (this.finished()) {
                    break;
                }
                if (this.checkError()) {
                    break;
                }
                if (monitor != null) {
                    execCommand.updateMonitor(monitor);
                }
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, execCommand.getMessage());
                this.executeArgFile(this.generateArgFile(execCommand.buildCommandLine(), execCommand.getArgFilePrefix()), execCommand.shouldCaptureOutput(), execCommand.getLauncherArgs(), execCommand.needsMemory());
                if (monitor == null || execCommand == runCommands.get(runCommands.size() - 1)) continue;
                monitor.subTask("");
            }
        }
        catch (Exception e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error execing " + this.scanSpec.getExecutable(), (Throwable)e);
            this.scanSpec.setException(e);
        }
        finally {
            this.runCleanupManagedLicense();
            this.setFinished();
        }
    }
}

