/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.configuration.SCAConfigurationUtil;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.AbstractScanSpecification;
import com.fortify.util.SCARunner.AdvancedSCAExec;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.SCAArgument;
import com.fortify.util.SCARunner.SCAFlagArgument;
import com.fortify.util.SCARunner.SCAValueArgument;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import com.fortify.util.SCARunner.specification.commands.ExecCommand;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AdvancedScanSpecification
extends AbstractScanSpecification
implements SmartScanSpecification {
    private List<AdvancedSCAExecCommand> commandsToRun = new ArrayList<AdvancedSCAExecCommand>();
    private Comparator<AdvancedSCAExecCommand> comparator = new Comparator<AdvancedSCAExecCommand>(){

        @Override
        public int compare(AdvancedSCAExecCommand o1, AdvancedSCAExecCommand o2) {
            return this.getWeight(o2) - this.getWeight(o2);
        }

        private int getWeight(AdvancedSCAExecCommand command) {
            int weight = 0;
            if (command instanceof CleanAdvancedSCAExecCommand) {
                weight = 1;
            } else if (command instanceof BuildAdvancedSCAExecCommand) {
                weight = 2;
            } else if (command instanceof ScanAdvancedSCAExecCommand) {
                weight = 3;
            } else if (command instanceof InfoAdvancedSCAExecCommand) {
                weight = 4;
            }
            return weight;
        }
    };

    public AdvancedScanSpecification(String executable) {
        super(executable);
    }

    @Override
    public AbstractSCAExec createExec() {
        return new AdvancedSCAExec(this);
    }

    public void addCommand(AdvancedSCAExecCommand com) {
        if (!this.commandsToRun.contains(com)) {
            this.commandsToRun.add(com);
        }
    }

    public AdvancedSCAExecCommand[] getRunCommands() {
        ArrayList<AdvancedSCAExecCommand> copy = new ArrayList<AdvancedSCAExecCommand>(this.commandsToRun);
        Collections.sort(copy, this.comparator);
        return copy.toArray(new AdvancedSCAExecCommand[copy.size()]);
    }

    public void removeCommand(AdvancedSCAExecCommand com) {
        this.commandsToRun.remove(com);
    }

    public void initializeGeneralScan(String buildID) {
        this.commandsToRun.clear();
        this.setBuildId(buildID);
        this.setMachineOut(true);
    }

    public CleanAdvancedSCAExecCommand getCleanCommand() {
        for (AdvancedSCAExecCommand next : this.commandsToRun) {
            if (!(next instanceof CleanAdvancedSCAExecCommand)) continue;
            return (CleanAdvancedSCAExecCommand)next;
        }
        return null;
    }

    public BuildAdvancedSCAExecCommand[] getBuildCommands() {
        ArrayList<BuildAdvancedSCAExecCommand> buildCommands = new ArrayList<BuildAdvancedSCAExecCommand>();
        for (AdvancedSCAExecCommand next : this.commandsToRun) {
            if (!(next instanceof BuildAdvancedSCAExecCommand)) continue;
            buildCommands.add((BuildAdvancedSCAExecCommand)next);
        }
        return buildCommands.toArray(new BuildAdvancedSCAExecCommand[buildCommands.size()]);
    }

    public ScanAdvancedSCAExecCommand getScanCommand() {
        for (AdvancedSCAExecCommand next : this.commandsToRun) {
            if (!(next instanceof ScanAdvancedSCAExecCommand)) continue;
            return (ScanAdvancedSCAExecCommand)next;
        }
        return null;
    }

    public InfoAdvancedSCAExecCommand getInfoCommand() {
        for (AdvancedSCAExecCommand next : this.commandsToRun) {
            if (!(next instanceof InfoAdvancedSCAExecCommand)) continue;
            return (InfoAdvancedSCAExecCommand)next;
        }
        return null;
    }

    @Override
    public List<? extends ExecCommand> getCommands() {
        ArrayList<AdvancedSCAExecCommand> copy = new ArrayList<AdvancedSCAExecCommand>(this.commandsToRun);
        Collections.sort(copy, this.comparator);
        return copy;
    }

    @Override
    public boolean shouldWaitForResults() {
        return false;
    }

    public static class ScanAdvancedSCAExecCommand
    extends AdvancedSCAExecCommand {
        private static final String SCAN = "Scan";
        private List<SCAArgument> scanArgs = new ArrayList<SCAArgument>();
        private String additionalScanArgs = null;
        private List<String> scanLauncherArgs = null;
        private String outPath;
        private String printedScan = null;
        private AdvancedScanSpecification spec;

        public ScanAdvancedSCAExecCommand(AdvancedScanSpecification spec) {
            this.spec = spec;
        }

        public void setOutPutFile(String path) {
            this.outPath = path;
            Iterator<SCAArgument> iterator = this.scanArgs.iterator();
            while (iterator.hasNext()) {
                SCAArgument argument = iterator.next();
                if (!"-f".equals(argument.getFlag())) continue;
                iterator.remove();
                break;
            }
            this.scanArgs.add(new SCAValueArgument("-f", path));
        }

        @Override
        public void setArguments(List<SCAArgument> scanArgs) {
            this.scanArgs = new ArrayList<SCAArgument>(scanArgs);
        }

        @Override
        public List<SCAArgument> getArguments() {
            return this.scanArgs;
        }

        public String getOutputPath() {
            return this.outPath;
        }

        public void clearRulepackArgs() {
            Iterator<SCAArgument> iterator = this.scanArgs.iterator();
            while (iterator.hasNext()) {
                SCAArgument scaArgument = iterator.next();
                String flag = scaArgument.getFlag();
                if (!"-rules".equals(flag) && !"-no-default-rules".equals(flag)) continue;
                iterator.remove();
            }
        }

        @Override
        public void setAdditionalArguments(String additionalScanArgs) {
            if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
                this.additionalScanArgs = additionalScanArgs;
            } else {
                Object[] strings = AbstractScanSpecification.extractLauncherArgs(additionalScanArgs);
                this.scanLauncherArgs = (List)strings[0];
                this.additionalScanArgs = (String)strings[1];
            }
            String file = ScanAdvancedSCAExecCommand.extractOutputArg(additionalScanArgs);
            if (file != null) {
                this.setOutPutFile(file);
            }
        }

        private static String extractOutputArg(String text) {
            String[] parsed = StringUtil.parseArguments(text);
            String output = null;
            boolean isOutput = false;
            for (String arg : parsed) {
                if (isOutput) {
                    output = arg;
                    break;
                }
                if (!"-f".equals(arg)) continue;
                isOutput = true;
            }
            return output;
        }

        @Override
        public String getAdditionalArguments() {
            return this.additionalScanArgs;
        }

        @Override
        public List<String> getLauncherArgs() {
            return this.scanLauncherArgs;
        }

        @Override
        public String buildCommandLine() {
            if (this.printedScan == null) {
                LinkedList<String> cmd = new LinkedList<String>();
                if (this.spec.getBuildId() != null) {
                    cmd.add("-b");
                    cmd.add(this.spec.getBuildId());
                }
                if (this.spec.isDebugging()) {
                    cmd.add("-debug");
                }
                if (this.scanLauncherArgs == null) {
                    this.scanLauncherArgs = new ArrayList<String>();
                }
                if (!this.scanLauncherArgs.contains("-scan")) {
                    this.scanLauncherArgs.add("-scan");
                }
                if (this.spec.getMachineOut()) {
                    cmd.add("-machine-output");
                }
                AbstractScanSpecification.appendArgumentsToCommand(cmd, this.getArguments());
                this.printedScan = AbstractScanSpecification.printArgs(cmd, this.getAdditionalArguments());
            }
            return this.printedScan;
        }

        public void setPrintedScan(String text) {
            if (text == null) {
                this.printedScan = null;
                return;
            }
            if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
                this.printedScan = text;
            } else {
                Object[] strings = AbstractScanSpecification.extractLauncherArgs(text);
                this.scanLauncherArgs = (List)strings[0];
                this.printedScan = (String)strings[1];
            }
            String file = ScanAdvancedSCAExecCommand.extractOutputArg(this.printedScan);
            if (file != null) {
                this.setOutPutFile(file);
            }
        }

        public void initializeGeneralScan() {
            if (!SCAConfigurationUtil.isDevInspect(this.spec.getExecutable())) {
                this.scanArgs.add(new SCAValueArgument("-format", "fpr"));
            }
        }

        @Override
        public String getArgFilePrefix() {
            return SCAN;
        }

        @Override
        public String getMessage() {
            return "Running scan... " + this.spec.getBuildId();
        }

        @Override
        public void updateMonitor(FortifyProgressMonitor monitor) {
            monitor.startScan();
        }
    }

    public static class BuildAdvancedSCAExecCommand
    extends AdvancedSCAExecCommand {
        private static final String BUILD = "Build";
        private List<SCAArgument> translationArgs = new ArrayList<SCAArgument>();
        private int numFiles = 0;
        private String additionalBuildArgs = null;
        private String printedTranslation = null;
        private Set<String> resourcesToScan = new HashSet<String>();
        private Set<String> classPaths = new HashSet<String>();
        private Set<String> excludedPaths = null;
        private List<String> translationLauncherArgs = null;
        private String javaVersion = null;
        private AdvancedScanSpecification spec;
        private String projectName;

        public BuildAdvancedSCAExecCommand(AdvancedScanSpecification spec) {
            this(spec, null);
        }

        public BuildAdvancedSCAExecCommand(AdvancedScanSpecification spec, String name) {
            this.spec = spec;
            this.projectName = name == null ? "" : name;
        }

        @Override
        public void setArguments(List<SCAArgument> translationArgs) {
            this.translationArgs = new ArrayList<SCAArgument>(translationArgs);
        }

        public void setLibDirs(List<String> paths) {
            if (paths.size() == 0) {
                return;
            }
            String classPath = StringUtil.buildClassPath(paths);
            this.translationArgs.add(new SCAValueArgument("-libdirs", classPath));
        }

        public void setClassPath(List<String> paths) {
            if (paths != null) {
                this.classPaths = new HashSet<String>(paths);
            }
            this.setListOfArgsToFlag(paths, "-cp");
        }

        public Set<String> getClassPath() {
            return this.classPaths;
        }

        public void setJavaVers(String version) {
            Iterator<SCAArgument> iterator = this.translationArgs.iterator();
            while (iterator.hasNext()) {
                SCAArgument scaArgument = iterator.next();
                if (!"-source".equals(scaArgument.getFlag())) continue;
                iterator.remove();
                break;
            }
            this.javaVersion = version;
            this.translationArgs.add(new SCAValueArgument("-source", this.javaVersion));
        }

        public String getJavaVers() {
            return this.javaVersion;
        }

        public void setSourcePath(List<String> paths) {
            this.setListOfArgsToFlag(paths, "-sourcepath");
        }

        private void setListOfArgsToFlag(List<String> args, String flag) {
            Iterator<SCAArgument> iterator = this.translationArgs.iterator();
            while (iterator.hasNext()) {
                SCAArgument scaArgument = iterator.next();
                if (!flag.equals(scaArgument.getFlag())) continue;
                iterator.remove();
                break;
            }
            if (args != null && args.size() > 0) {
                String concatedArgs = StringUtil.buildClassPath(args);
                this.translationArgs.add(new SCAValueArgument(flag, concatedArgs));
            }
        }

        @Override
        public List<SCAArgument> getArguments() {
            return this.translationArgs;
        }

        @Override
        public String buildCommandLine() {
            if (this.printedTranslation == null) {
                LinkedList<String> cmd = new LinkedList<String>();
                if (this.spec.getBuildId() != null) {
                    cmd.add("-b");
                    cmd.add(this.spec.getBuildId());
                }
                if (this.spec.isDebugging()) {
                    cmd.add("-debug");
                }
                if (this.spec.getMachineOut()) {
                    cmd.add("-machine-output");
                }
                if (this.excludedPaths != null) {
                    for (String excl : this.excludedPaths) {
                        cmd.add("-exclude");
                        cmd.add(excl);
                    }
                }
                AbstractScanSpecification.appendArgumentsToCommand(cmd, this.getArguments());
                cmd.addAll(this.resourcesToScan);
                this.printedTranslation = AbstractScanSpecification.printArgs(cmd, this.getAdditionalArguments());
            }
            return this.printedTranslation;
        }

        public void setResourcesToScan(List<String> paths) {
            this.numFiles = paths.size();
            this.resourcesToScan = new HashSet<String>(paths);
        }

        public void addResourcesToScan(List<String> paths) {
            this.numFiles += paths.size();
            this.resourcesToScan.addAll(paths);
        }

        public Set<String> getResourcesToScan() {
            return this.resourcesToScan;
        }

        @Override
        public void setAdditionalArguments(String additionalBuildArgs) {
            if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
                this.additionalBuildArgs = additionalBuildArgs;
            } else {
                Object[] strings = AbstractScanSpecification.extractLauncherArgs(additionalBuildArgs);
                this.translationLauncherArgs = (List)strings[0];
                this.additionalBuildArgs = (String)strings[1];
            }
        }

        public int getNumberOfTranslationFiles() {
            return this.numFiles;
        }

        @Override
        public String getAdditionalArguments() {
            return this.additionalBuildArgs;
        }

        public void setPrintedTranslation(String text) {
            if (text == null) {
                this.printedTranslation = null;
                return;
            }
            if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
                this.printedTranslation = text;
            } else {
                Object[] strings = AbstractScanSpecification.extractLauncherArgs(text);
                this.translationLauncherArgs = (List)strings[0];
                this.printedTranslation = (String)strings[1];
            }
        }

        public void setExcludedPaths(Set<String> excluded) {
            this.excludedPaths = excluded;
        }

        public String getProjectName() {
            return this.projectName;
        }

        @Override
        public List<String> getLauncherArgs() {
            return this.translationLauncherArgs;
        }

        @Override
        public String getArgFilePrefix() {
            return this.projectName + BUILD;
        }

        @Override
        public String getMessage() {
            return "Running translation " + this.projectName;
        }

        @Override
        public void updateMonitor(FortifyProgressMonitor monitor) {
            monitor.startBuild(this.getNumberOfTranslationFiles());
        }
    }

    public static class CleanAdvancedSCAExecCommand
    extends AdvancedSCAExecCommand {
        private AdvancedScanSpecification spec;
        private static final String CLEAN = "Clean";

        public CleanAdvancedSCAExecCommand(AdvancedScanSpecification spec) {
            this.spec = spec;
        }

        @Override
        public String buildCommandLine() {
            LinkedList<String> cmd = new LinkedList<String>();
            if (this.spec.getBuildId() != null) {
                cmd.add("-b");
                cmd.add(this.spec.getBuildId());
            }
            cmd.add("-clean");
            return AbstractScanSpecification.printArgs(cmd, null);
        }

        @Override
        public String getArgFilePrefix() {
            return CLEAN;
        }

        @Override
        public List<String> getLauncherArgs() {
            return null;
        }

        @Override
        public boolean needsMemory() {
            return false;
        }

        @Override
        public String getMessage() {
            return "Running clean... " + this.spec.getBuildId();
        }

        @Override
        public void setArguments(List<SCAArgument> args) {
        }

        @Override
        public List<SCAArgument> getArguments() {
            return null;
        }
    }

    public static class InfoAdvancedSCAExecCommand
    extends AdvancedSCAExecCommand {
        private List<SCAArgument> infoArguments = new ArrayList<SCAArgument>();
        private static final String INFO = "Info";

        @Override
        public List<SCAArgument> getArguments() {
            return this.infoArguments;
        }

        public void addInfoArgument(String arg) {
            this.infoArguments.addAll(Collections.singletonList(new SCAFlagArgument(arg)));
        }

        @Override
        public void setArguments(List<SCAArgument> args) {
            this.infoArguments = new ArrayList<SCAArgument>(args);
        }

        @Override
        public String buildCommandLine() {
            LinkedList<String> cmd = new LinkedList<String>();
            AbstractScanSpecification.appendArgumentsToCommand(cmd, this.getArguments());
            return AbstractScanSpecification.printArgs(cmd, null);
        }

        @Override
        public String getArgFilePrefix() {
            return INFO;
        }

        @Override
        public List<String> getLauncherArgs() {
            return null;
        }

        @Override
        public boolean shouldCaptureOutput() {
            return true;
        }

        @Override
        public String getMessage() {
            return "Running Info Exec...";
        }
    }

    public static abstract class AdvancedSCAExecCommand
    implements ExecCommand {
        @Override
        public abstract String buildCommandLine();

        @Override
        public abstract List<String> getLauncherArgs();

        @Override
        public abstract String getArgFilePrefix();

        @Override
        public abstract String getMessage();

        public abstract void setArguments(List<SCAArgument> var1);

        public abstract List<SCAArgument> getArguments();

        @Override
        public boolean shouldCaptureOutput() {
            return false;
        }

        @Override
        public boolean needsMemory() {
            return true;
        }

        @Override
        public void updateMonitor(FortifyProgressMonitor monitor) {
        }

        public void setAdditionalArguments(String args) {
        }

        public String getAdditionalArguments() {
            return null;
        }
    }
}

