/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.SCAExecCommands;
import com.fortify.util.SCARunner.ScanSpecification;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import java.io.File;
import java.io.IOException;

public class SCAExec
extends AbstractSCAExec {
    private static ILogger logger = MessageManager.getLogger(SCAExec.class);
    private static final String BUILD = "Build";
    private static final String CLEAN = "Clean";
    private static final String SCAN = "Scan";
    private static final String INFO = "Info";

    public SCAExec(SmartScanSpecification spec) {
        super(spec);
    }

    private ScanSpecification getScanSpec() {
        if (this.scanSpec instanceof ScanSpecification) {
            return (ScanSpecification)this.scanSpec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ScanSpecification scanSpec = this.getScanSpec();
        if (scanSpec == null) {
            return;
        }
        SCAExecCommands[] runCommands = scanSpec.getRunCommands();
        try {
            FortifyProgressMonitor monitor = this.getMonitor();
            this.setStarted();
            if (monitor != null) {
                monitor.setTaskName(scanSpec.getSpecificationName());
            }
            for (SCAExecCommands runCommand : runCommands) {
                if (this.canceled()) {
                    scanSpec.setCancelled(true);
                    break;
                }
                if (this.finished()) {
                    break;
                }
                if (this.checkError()) {
                    break;
                }
                if (runCommand == SCAExecCommands.CLEAN) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Running clean..." + scanSpec.getBuildId());
                    this.executeArgFile(this.generateArgFile(scanSpec.buildCleanCommandLine(), CLEAN), CLEAN, scanSpec);
                    continue;
                }
                if (runCommand == SCAExecCommands.TRANSLATE) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Running translation" + scanSpec.getBuildId());
                    if (monitor != null) {
                        monitor.startBuild(scanSpec.getNumberOfTranslationFiles());
                    }
                    this.executeArgFile(this.generateArgFile(scanSpec.buildTranslationCommandLine(), BUILD), BUILD, scanSpec);
                    if (monitor == null) continue;
                    monitor.subTask("");
                    continue;
                }
                if (runCommand == SCAExecCommands.SCAN) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Running scan..." + scanSpec.getBuildId());
                    if (monitor != null) {
                        monitor.startScan();
                    }
                    this.executeArgFile(this.generateArgFile(scanSpec.buildScanCommandLine(), SCAN), SCAN, scanSpec);
                    continue;
                }
                if (runCommand == SCAExecCommands.INFO) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Running Info Exec...");
                    this.executeArgFile(this.generateArgFile(scanSpec.buildInfoCommandLine(), INFO), true, null, true);
                    continue;
                }
                if (runCommand != SCAExecCommands.GENERATE_ARG_FILES) continue;
                this.generateArgFiles(scanSpec);
            }
        }
        catch (Exception e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error execing " + scanSpec.getExecutable(), (Throwable)e);
            scanSpec.setException(e);
        }
        finally {
            this.runCleanupManagedLicense();
            this.setFinished();
        }
    }

    private void generateArgFiles(ScanSpecification scanSpec) {
        this.generateArgFile(scanSpec.buildCleanCommandLine(), CLEAN);
        this.generateArgFile(scanSpec.buildScanCommandLine(), BUILD);
        this.generateArgFile(scanSpec.buildTranslationCommandLine(), SCAN);
    }

    private void executeArgFile(File argFile, String stage, ScanSpecification scanSpec) throws IOException {
        if (BUILD.equals(stage)) {
            this.executeArgFile(argFile, false, scanSpec.getTranslationLauncherArgs(), !stage.equals(CLEAN));
        } else if (SCAN.equals(stage)) {
            this.executeArgFile(argFile, false, scanSpec.getScanLauncherArgs(), !stage.equals(CLEAN));
        } else {
            this.executeArgFile(argFile, false, null, !stage.equals(CLEAN));
        }
    }
}

