/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.RunnableWithProgress;
import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;

public class SCAExecRunner
implements RunnableWithProgress {
    static ILogger logger = MessageManager.getLogger(SCAExecRunner.class);
    private SmartScanSpecification scanSpec;
    private AbstractSCAExec scanner;
    private FortifyProgressMonitor monitor;

    public SCAExecRunner(SmartScanSpecification spec) {
        this.scanSpec = spec;
        this.scanner = spec.createExec();
    }

    @Override
    public void run() {
        this.monitor.start();
        this.monitor.setTaskName("Starting Scan " + this.scanSpec.getBuildId());
        this.scanner.setMonitor(this.monitor);
        Thread runner = new Thread(this.scanner);
        runner.start();
        this.poll(this.scanner, this.monitor);
        this.scanSpec.setCancelled(this.monitor.isCanceled());
        this.monitor.done();
        if (this.scanner.checkError()) {
            int returncode;
            StringBuffer errors = new StringBuffer();
            for (String error : this.scanSpec.getErrorList()) {
                errors.append(System.getProperty("line.separator"));
                errors.append(error);
                if (!error.contains("Copyright (c)")) continue;
                break;
            }
            if (!this.scanner.canceled() && (returncode = this.scanner.getReturnCode()) != 0) {
                throw new FortifyException(new Message(4, errors.toString()));
            }
        }
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Scan complete");
    }

    private void poll(AbstractSCAExec scanner, FortifyProgressMonitor monitor) {
        long pollTime = 100L;
        while (!monitor.isCanceled()) {
            try {
                Thread.currentThread();
                Thread.sleep(pollTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!scanner.finished()) continue;
        }
        if (monitor.isCanceled()) {
            scanner.interrupt();
            long startTime = System.currentTimeMillis();
            while (!scanner.finished()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(pollTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= 60000L) continue;
                logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.LOG, "SCA didn't finish managed license cleanup in expected time. If you use managed license, the lease might be not released properly. If you can not run a scan due to unavailable license error after your lease expiration timeout, please contact your administrator.");
                break;
            }
            monitor.done();
        }
    }

    @Override
    public void setProgressMonitor(FortifyProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

