/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.util.SCARunner.SCAArgument;
import com.fortify.util.SCARunner.ScanSpecification;
import java.util.List;

public class SCAValueArgument
extends SCAArgument {
    private final String flag;
    private final String value;
    private boolean multi = false;

    public SCAValueArgument(String flag, String value) {
        if (flag == null) {
            throw new NullPointerException("Flag may not be null");
        }
        if (value == null) {
            throw new NullPointerException("Value may not be null");
        }
        this.flag = flag;
        this.value = value;
        if (ScanSpecification.getMultiFlags().contains(flag)) {
            this.multi = true;
        }
    }

    @Override
    public String getFlag() {
        return this.flag;
    }

    public String getArgumentValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCAValueArgument that = (SCAValueArgument)o;
        if (!this.multi) {
            return this.flag.equals(that.flag);
        }
        return this.flag.equals(that.flag) && this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return this.flag.hashCode();
    }

    @Override
    public void addToCommand(List<String> cmd) {
        cmd.add(this.flag);
        cmd.add(this.value);
    }

    public void setMulti(boolean b) {
        this.multi = b;
    }
}

