/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner;

import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.AbstractScanSpecification;
import com.fortify.util.SCARunner.SCAArgument;
import com.fortify.util.SCARunner.SCAExec;
import com.fortify.util.SCARunner.SCAExecCommands;
import com.fortify.util.SCARunner.SCAFlagArgument;
import com.fortify.util.SCARunner.SCAValueArgument;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import com.fortify.util.SCARunner.specification.commands.ExecCommand;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ScanSpecification
extends AbstractScanSpecification
implements SmartScanSpecification {
    private List<SCAExecCommands> commandsToRun = new ArrayList<SCAExecCommands>();
    private List<SCAArgument> translationArgs = new ArrayList<SCAArgument>();
    private List<SCAArgument> scanArgs = new ArrayList<SCAArgument>();
    private List<SCAFlagArgument> infoArguments = new ArrayList<SCAFlagArgument>();
    private String outPath;
    private String additionalScanArgs = null;
    private String additionalBuildArgs = null;
    private int numFiles = 0;
    private String printedTranslation = null;
    private String printedScan = null;
    private Set<String> resourcesToScan = new HashSet<String>();
    private Set<String> excludedPaths = null;
    private List<String> translationLauncherArgs = null;
    private List<String> scanLauncherArgs = null;

    public ScanSpecification(String executable) {
        super(executable);
    }

    @Override
    public AbstractSCAExec createExec() {
        return new SCAExec(this);
    }

    public void addCommand(SCAExecCommands com) {
        if (!this.commandsToRun.contains(com)) {
            this.commandsToRun.add(com);
        }
    }

    public void setOutPutFile(String path) {
        this.outPath = path;
        Iterator<SCAArgument> iterator = this.scanArgs.iterator();
        while (iterator.hasNext()) {
            SCAArgument argument = iterator.next();
            if (!"-f".equals(argument.getFlag())) continue;
            iterator.remove();
            break;
        }
        this.scanArgs.add(new SCAValueArgument("-f", path));
    }

    @Deprecated
    public void addScanArguments(List<SCAArgument> scanArgs) {
        this.scanArgs.removeAll(scanArgs);
        this.scanArgs.addAll(scanArgs);
    }

    public void setScanArguments(List<SCAArgument> scanArgs) {
        this.scanArgs = new ArrayList<SCAArgument>(scanArgs);
    }

    @Deprecated
    public void addTranslationArgs(List<SCAArgument> translationArgs) {
        this.translationArgs.removeAll(translationArgs);
        this.translationArgs.addAll(translationArgs);
    }

    public void setTranslationArgs(List<SCAArgument> translationArgs) {
        this.translationArgs = new ArrayList<SCAArgument>(translationArgs);
    }

    public void setResourcesToScan(List<String> paths) {
        this.numFiles = paths.size();
        this.resourcesToScan = new HashSet<String>(paths);
    }

    public void addResourcesToScan(List<String> paths) {
        this.numFiles += paths.size();
        this.resourcesToScan.addAll(paths);
    }

    public void setLibDirs(List<String> paths) {
        if (paths.size() == 0) {
            return;
        }
        String classPath = StringUtil.buildClassPath(paths);
        this.translationArgs.add(new SCAValueArgument("-libdirs", classPath));
    }

    public void setClassPath(List<String> paths) {
        if (paths.size() == 0) {
            return;
        }
        String classPath = StringUtil.buildClassPath(paths);
        Iterator<SCAArgument> iterator = this.translationArgs.iterator();
        while (iterator.hasNext()) {
            SCAArgument scaArgument = iterator.next();
            if (!"-cp".equals(scaArgument.getFlag())) continue;
            iterator.remove();
            break;
        }
        this.translationArgs.add(new SCAValueArgument("-cp", classPath));
    }

    public List<SCAArgument> getScanArguments() {
        return this.scanArgs;
    }

    public List<SCAArgument> getTranslationArguments() {
        return this.translationArgs;
    }

    public SCAExecCommands[] getRunCommands() {
        ArrayList<SCAExecCommands> ret = new ArrayList<SCAExecCommands>();
        if (this.commandsToRun.remove(SCAExecCommands.CLEAN)) {
            ret.add(SCAExecCommands.CLEAN);
        }
        if (this.commandsToRun.remove(SCAExecCommands.TRANSLATE)) {
            ret.add(SCAExecCommands.TRANSLATE);
        }
        if (this.commandsToRun.remove(SCAExecCommands.SCAN)) {
            ret.add(SCAExecCommands.SCAN);
        }
        ret.addAll(this.commandsToRun);
        this.commandsToRun.addAll(ret);
        return ret.toArray(new SCAExecCommands[ret.size()]);
    }

    public void removeCommand(SCAExecCommands com) {
        this.commandsToRun.remove(com);
    }

    public void initializeGeneralScan(String buildID) {
        this.commandsToRun.clear();
        this.addCommand(SCAExecCommands.CLEAN);
        this.addCommand(SCAExecCommands.TRANSLATE);
        this.addCommand(SCAExecCommands.SCAN);
        this.setBuildId(buildID);
        this.setMachineOut(true);
        this.scanArgs.add(new SCAValueArgument("-format", "fpr"));
    }

    public String getOutputPath() {
        return this.outPath;
    }

    public void setAdditionalTranslationArg(String additionalBuildArgs) {
        if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            this.additionalBuildArgs = additionalBuildArgs;
        } else {
            Object[] strings = ScanSpecification.extractLauncherArgs(additionalBuildArgs);
            this.translationLauncherArgs = (List)strings[0];
            this.additionalBuildArgs = (String)strings[1];
        }
    }

    public void setAdditionalScanArg(String additionalScanArgs) {
        if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            this.additionalScanArgs = additionalScanArgs;
        } else {
            Object[] strings = ScanSpecification.extractLauncherArgs(additionalScanArgs);
            this.scanLauncherArgs = (List)strings[0];
            this.additionalScanArgs = (String)strings[1];
        }
    }

    public List<SCAFlagArgument> getInfoArguments() {
        return this.infoArguments;
    }

    public void addInfoArgument(String arg) {
        this.infoArguments.add(new SCAFlagArgument(arg));
    }

    public int getNumberOfTranslationFiles() {
        return this.numFiles;
    }

    public String buildInfoCommandLine() {
        LinkedList<String> cmd = new LinkedList<String>();
        ScanSpecification.appendArgumentsToCommand(cmd, this.getInfoArguments());
        return ScanSpecification.printArgs(cmd, null);
    }

    public String buildScanCommandLine() {
        if (this.printedScan == null) {
            LinkedList<String> cmd = new LinkedList<String>();
            if (this.getBuildId() != null) {
                cmd.add("-b");
                cmd.add(this.getBuildId());
            }
            if (this.isDebugging()) {
                cmd.add("-debug");
            }
            if (this.scanLauncherArgs == null) {
                this.scanLauncherArgs = new ArrayList<String>();
            }
            if (!this.scanLauncherArgs.contains("-scan")) {
                this.scanLauncherArgs.add("-scan");
            }
            if (this.getMachineOut()) {
                cmd.add("-machine-output");
            }
            ScanSpecification.appendArgumentsToCommand(cmd, this.getScanArguments());
            this.printedScan = ScanSpecification.printArgs(cmd, this.getAdditionalScanArgs());
        }
        return this.printedScan;
    }

    public String buildTranslationCommandLine() {
        if (this.printedTranslation == null) {
            LinkedList<String> cmd = new LinkedList<String>();
            if (this.getBuildId() != null) {
                cmd.add("-b");
                cmd.add(this.getBuildId());
            }
            if (this.isDebugging()) {
                cmd.add("-debug");
            }
            if (this.getMachineOut()) {
                cmd.add("-machine-output");
            }
            if (this.excludedPaths != null) {
                for (String excl : this.excludedPaths) {
                    cmd.add("-exclude");
                    cmd.add(excl);
                }
            }
            ScanSpecification.appendArgumentsToCommand(cmd, this.getTranslationArguments());
            cmd.addAll(this.resourcesToScan);
            this.printedTranslation = ScanSpecification.printArgs(cmd, this.getAdditionalBuildArgs());
        }
        return this.printedTranslation;
    }

    public String buildCleanCommandLine() {
        LinkedList<String> cmd = new LinkedList<String>();
        if (this.getBuildId() != null) {
            cmd.add("-b");
            cmd.add(this.getBuildId());
        }
        cmd.add("-clean");
        return ScanSpecification.printArgs(cmd, null);
    }

    public String getAdditionalScanArgs() {
        return this.additionalScanArgs;
    }

    public String getAdditionalBuildArgs() {
        return this.additionalBuildArgs;
    }

    public void setPrintedTranslation(String text) {
        if (text == null) {
            this.printedTranslation = null;
            return;
        }
        if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            this.printedTranslation = text;
        } else {
            Object[] strings = ScanSpecification.extractLauncherArgs(text);
            this.translationLauncherArgs = (List)strings[0];
            this.printedTranslation = (String)strings[1];
        }
    }

    public void setPrintedScan(String text) {
        if (text == null) {
            this.printedScan = null;
            return;
        }
        if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            this.printedScan = text;
        } else {
            Object[] strings = ScanSpecification.extractLauncherArgs(text);
            this.scanLauncherArgs = (List)strings[0];
            this.printedScan = (String)strings[1];
        }
    }

    public void setExcludedPaths(Set<String> excluded) {
        this.excludedPaths = excluded;
    }

    public void clearRulepackArgs() {
        Iterator<SCAArgument> iterator = this.scanArgs.iterator();
        while (iterator.hasNext()) {
            SCAArgument scaArgument = iterator.next();
            String flag = scaArgument.getFlag();
            if (!"-rules".equals(flag) && !"-no-default-rules".equals(flag)) continue;
            iterator.remove();
        }
    }

    public List<String> getTranslationLauncherArgs() {
        return this.translationLauncherArgs;
    }

    public List<String> getScanLauncherArgs() {
        return this.scanLauncherArgs;
    }

    @Override
    public List<? extends ExecCommand> getCommands() {
        return null;
    }

    @Override
    public boolean shouldWaitForResults() {
        return false;
    }
}

