/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner.specification;

import com.fortify.configuration.SCAConfigurationUtil;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import com.fortify.util.SCARunner.specification.commands.CleanExecCommand;
import com.fortify.util.SCARunner.specification.commands.GeneralTranslationExecCommand;
import com.fortify.util.SCARunner.specification.commands.InfoExecCommand;
import com.fortify.util.SCARunner.specification.commands.JavaTranslationExecCommand;
import com.fortify.util.SCARunner.specification.commands.ScanExecCommand;

public class ExecCommandFabric {
    private SmartScanSpecification spec;

    public ExecCommandFabric(SmartScanSpecification specification) {
        this.spec = specification;
    }

    public InfoExecCommand createNewInfoCommand() {
        return new InfoExecCommand();
    }

    public CleanExecCommand createNewCleanCommand() {
        return new CleanExecCommand(this.spec.getBuildId());
    }

    public JavaTranslationExecCommand createNewJavaTranslationCommand(String projectName) {
        return new JavaTranslationExecCommand(projectName, this.spec.getBuildId());
    }

    public GeneralTranslationExecCommand createNewGeneralTranslationCommand(String projectName) {
        return new GeneralTranslationExecCommand(projectName, this.spec.getBuildId());
    }

    public ScanExecCommand createNewScanCommand() {
        boolean devInspect = SCAConfigurationUtil.isDevInspect(this.spec.getExecutable());
        return new ScanExecCommand(this.spec.getBuildId(), devInspect);
    }
}

