/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner.specification;

import com.fortify.util.SCARunner.AbstractSCAExec;
import com.fortify.util.SCARunner.AdvancedSCAExec;
import com.fortify.util.SCARunner.specification.SmartScanSpecification;
import com.fortify.util.SCARunner.specification.commands.AbstractExecCommand;
import com.fortify.util.SCARunner.specification.commands.CleanExecCommand;
import com.fortify.util.SCARunner.specification.commands.ExecCommand;
import com.fortify.util.SCARunner.specification.commands.InfoExecCommand;
import com.fortify.util.SCARunner.specification.commands.ScanExecCommand;
import com.fortify.util.SCARunner.specification.commands.TranslationExecCommand;
import com.fortify.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NewScanSpecificaton
implements SmartScanSpecification {
    private String scaExecutable;
    private String buildId;
    private String sqlType;
    private boolean quickScan;
    private String memory;
    private boolean cancelled;
    private Exception exception;
    private boolean shouldWaitForResult;
    private String argFilePath;
    private int returnCode;
    private List<String> errors = new ArrayList<String>();
    private List<String> outputLines = new ArrayList<String>();
    private List<AbstractExecCommand> commands = new ArrayList<AbstractExecCommand>();
    private static Comparator<AbstractExecCommand> comparator = new Comparator<AbstractExecCommand>(){

        @Override
        public int compare(AbstractExecCommand o1, AbstractExecCommand o2) {
            return this.getWeight(o2) - this.getWeight(o2);
        }

        private int getWeight(AbstractExecCommand command) {
            int weight = 0;
            if (command instanceof CleanExecCommand) {
                weight = 1;
            } else if (command instanceof TranslationExecCommand) {
                weight = 2;
            } else if (command instanceof ScanExecCommand) {
                weight = 3;
            } else if (command instanceof InfoExecCommand) {
                weight = 4;
            }
            return weight;
        }
    };

    public NewScanSpecificaton(String buildId, String scaExecutable) {
        this.scaExecutable = scaExecutable;
        this.buildId = buildId;
    }

    @Override
    public String getSpecificationName() {
        return this.buildId;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean state) {
        this.cancelled = state;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception e) {
        this.exception = e;
    }

    @Override
    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String value) {
        this.memory = value;
    }

    @Override
    public String getBuildId() {
        return this.buildId;
    }

    @Override
    public List<? extends ExecCommand> getCommands() {
        Collections.sort(this.commands, comparator);
        return this.commands;
    }

    @Override
    public String getExecutable() {
        return this.scaExecutable;
    }

    @Override
    public String getSQLType() {
        return this.sqlType;
    }

    @Override
    public boolean isQuickScanEnabled() {
        return this.quickScan;
    }

    public void setQuickScanEnabled(boolean state) {
        this.quickScan = state;
    }

    public void addCommand(AbstractExecCommand command) {
        this.commands.add(command);
    }

    @Override
    public void setReturnCode(int code) {
        this.returnCode = code;
    }

    @Override
    public void addError(String error) {
        if (!StringUtil.isEmpty(error)) {
            this.errors.add(error);
        }
    }

    @Override
    public String getArgFilePath() {
        return this.argFilePath;
    }

    @Override
    public void addOutputLine(String msg) {
        if (!StringUtil.isEmpty(msg)) {
            this.outputLines.add(msg);
        }
    }

    @Override
    public AbstractSCAExec createExec() {
        return new AdvancedSCAExec(this);
    }

    @Override
    public List<String> getErrorList() {
        return this.errors;
    }

    @Override
    public boolean shouldWaitForResults() {
        return this.shouldWaitForResult;
    }

    public void setShouldWaitForResult(boolean shouldWaitForResult) {
        this.shouldWaitForResult = shouldWaitForResult;
    }

    @Override
    public boolean failed() {
        return this.exception != null || this.returnCode != 0;
    }
}

