/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner.specification.commands;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.specification.commands.ExecCommand;
import com.fortify.util.StringUtil;
import com.fortify.util.WindowsArgProtector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractExecCommand
implements ExecCommand {
    static ILogger logger = MessageManager.getLogger(AbstractExecCommand.class);
    public static final String OPT_MACHOUT = "-machine-output";
    public static final String OPT_DEBUG = "-debug";
    public static List<String> LAUNCHER_ARG_PREFIXES = Arrays.asList("-flaunch_", "-autoheap", "-64", "-X", "-VM:", "-scan");
    private boolean machineOut;
    private boolean debugging;

    public boolean isMachineOut() {
        return this.machineOut;
    }

    public void setMachineOut(boolean machineOut) {
        this.machineOut = machineOut;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    protected String printArgs(List<String> args) {
        StringBuilder buf = new StringBuilder();
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            buf.append(WindowsArgProtector.quote(s));
            if (!iterator.hasNext()) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public boolean shouldCaptureOutput() {
        return false;
    }

    @Override
    public void updateMonitor(FortifyProgressMonitor monitor) {
    }

    protected List<String> extractLauncherArgs(List<String> args) {
        return this.processLauncherArgs(args, true);
    }

    protected List<String> getListWithLauncherArgsRemoved(List<String> args) {
        return this.processLauncherArgs(args, false);
    }

    private List<String> processLauncherArgs(List<String> args, boolean saveLaunchArgsOnly) {
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : args) {
            boolean isLaunch = false;
            for (String prefix : LAUNCHER_ARG_PREFIXES) {
                if (!arg.startsWith(prefix)) continue;
                isLaunch = true;
                break;
            }
            if (!isLaunch) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Identified non-launcher argument: " + arg);
            } else {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Identified launcher argument: " + arg);
            }
            if (isLaunch != saveLaunchArgsOnly) continue;
            result.add(arg);
        }
        return result;
    }

    @Override
    public boolean needsMemory() {
        return true;
    }

    @Override
    public abstract String buildCommandLine();

    @Override
    public abstract List<String> getLauncherArgs();

    @Override
    public abstract String getArgFilePrefix();

    @Override
    public abstract String getMessage();

    public static abstract class BuildSpecificCommand
    extends AbstractExecCommand {
        public static final String OPT_BUILDID = "-b";
        protected String buildId;

        public BuildSpecificCommand(String buildId) {
            if (StringUtil.isEmpty(buildId)) {
                throw new IllegalArgumentException("Build Id can't be null or empty");
            }
            this.buildId = buildId;
        }

        public String getBuildId() {
            return this.buildId;
        }
    }
}

