/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner.specification.commands;

import com.fortify.util.SCARunner.specification.commands.TranslationExecCommand;
import com.fortify.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JavaTranslationExecCommand
extends TranslationExecCommand {
    public static final String CLASSPATH_FLAG = "-cp";
    public static final String SOURCE_PATH_FLAG = "-sourcepath";
    public static final String SOURCE_FLAG = "-source";
    public static final String BUILD_DIR_FLAG = "-java-build-dir";
    private Set<String> classPath;
    private Set<String> sourcePath;
    private String javaVersion;
    private String javaBuildDir;

    public JavaTranslationExecCommand(String projectName, String buildId) {
        super(projectName, buildId);
    }

    public String getJavaBuildDir() {
        return this.javaBuildDir;
    }

    public void setJavaBuildDir(String javaBuildDir) {
        this.javaBuildDir = javaBuildDir;
    }

    public Set<String> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(Collection<String> classPath) {
        this.classPath = classPath != null ? new HashSet<String>(classPath) : Collections.emptySet();
    }

    public Set<String> getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(Collection<String> sourcePath) {
        this.sourcePath = sourcePath != null ? new HashSet<String>(sourcePath) : Collections.emptySet();
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Override
    protected void collectLanguageSpecificTranslationArgs(List<String> args) {
        if (args == null) {
            return;
        }
        if (!StringUtil.isEmpty(this.javaVersion)) {
            args.add(SOURCE_FLAG);
            args.add(this.javaVersion);
        }
        if (!this.classPath.isEmpty()) {
            args.add(CLASSPATH_FLAG);
            args.add(StringUtil.buildClassPath(new ArrayList<String>(this.classPath)));
        }
        if (!this.sourcePath.isEmpty()) {
            args.add(SOURCE_PATH_FLAG);
            args.add(StringUtil.buildClassPath(new ArrayList<String>(this.sourcePath)));
        }
        if (!StringUtil.isEmpty(this.javaBuildDir)) {
            args.add(BUILD_DIR_FLAG);
            args.add(this.javaBuildDir);
        }
    }
}

