/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner.specification.commands;

import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.SCARunner.specification.commands.AbstractExecCommand;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScanExecCommand
extends AbstractExecCommand.BuildSpecificCommand {
    private static final String SCAN = "Scan";
    public static final String OPT_SCAN = "-scan";
    public static final String FILE_FLAG = "-f";
    public static final String NO_DEFAULT_RULES = "-no-default-rules";
    public static final String RULES_FLAG = "-rules";
    public static final String FORMAT_FLAG = "-format";
    public static final String FPR = "fpr";
    public static final String FINDBUGS_FLAG = "-findbugs";
    private List<String> additionalArgs = new ArrayList<String>(0);
    private String outputPath;
    private List<String> rulepacks;
    private boolean findBugs;
    private boolean devInspect;

    public ScanExecCommand(String buildId, boolean devInspect) {
        super(buildId);
        this.devInspect = devInspect;
    }

    public boolean isDevInspect() {
        return this.devInspect;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setFindBugsEnablement(boolean state) {
        this.findBugs = state;
    }

    public void setAdditionalArgs(List<String> additionalArgs) {
        if (additionalArgs == null || additionalArgs.isEmpty()) {
            additionalArgs = new ArrayList<String>(0);
        }
        this.additionalArgs = additionalArgs;
    }

    public void setRulepacks(List<String> rulepacks) {
        this.rulepacks = rulepacks;
    }

    @Override
    public String buildCommandLine() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.getBuildId() != null) {
            cmd.add("-b");
            cmd.add(this.getBuildId());
        }
        if (!this.isDevInspect()) {
            cmd.add(FORMAT_FLAG);
            cmd.add(FPR);
        }
        if (this.isDebugging()) {
            cmd.add("-debug");
        }
        if (this.findBugs) {
            cmd.add(FINDBUGS_FLAG);
        }
        if (this.isMachineOut()) {
            cmd.add("-machine-output");
        }
        if (!StringUtil.isEmpty(this.outputPath)) {
            cmd.add(FILE_FLAG);
            cmd.add(this.outputPath);
        }
        if (this.rulepacks != null && !this.rulepacks.isEmpty()) {
            cmd.add(NO_DEFAULT_RULES);
            for (String rulepack : this.rulepacks) {
                cmd.add(RULES_FLAG);
                cmd.add(rulepack);
            }
        }
        if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            cmd.addAll(this.extractLauncherArgs(this.additionalArgs));
        } else {
            cmd.addAll(this.additionalArgs);
        }
        return this.printArgs(cmd);
    }

    @Override
    public List<String> getLauncherArgs() {
        ArrayList<String> launcherArgs = new ArrayList<String>();
        launcherArgs.add(OPT_SCAN);
        if (!SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            launcherArgs.addAll(this.extractLauncherArgs(this.additionalArgs));
        }
        return launcherArgs;
    }

    @Override
    public String getArgFilePrefix() {
        return SCAN;
    }

    @Override
    public String getMessage() {
        return "Running scan... " + this.getBuildId();
    }

    public void setAdditionalArguments(String argsText) {
        String[] parsed = StringUtil.parseArguments(argsText);
        this.additionalArgs = Arrays.asList(parsed);
    }
}

