/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.SCARunner.specification.commands;

import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.SCARunner.FortifyProgressMonitor;
import com.fortify.util.SCARunner.specification.commands.AbstractExecCommand;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class TranslationExecCommand
extends AbstractExecCommand.BuildSpecificCommand {
    public static final String BUILD = "Build";
    public static final String OPT_EXCLUDE = "-exclude";
    public static final String OPT_SQL = "-Dcom.fortify.sca.fileextensions.sql=";
    private Set<String> sourcesToScan;
    private Set<String> excludedPaths;
    private String projectName;
    private List<String> additionalArgs;
    private String sqlType;

    public TranslationExecCommand(String projectName, String buildId) {
        super(buildId);
        this.projectName = projectName;
        this.sourcesToScan = new HashSet<String>();
        this.excludedPaths = new HashSet<String>();
        this.additionalArgs = new ArrayList<String>(0);
    }

    public Set<String> getExcludedPaths() {
        return this.excludedPaths;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    @Override
    public String buildCommandLine() {
        ArrayList<String> args = new ArrayList<String>(this.additionalArgs.size() + 4 + this.excludedPaths.size() * 2 + this.sourcesToScan.size());
        args.add("-b");
        args.add(this.buildId);
        if (this.isDebugging()) {
            args.add("-debug");
        }
        if (this.isMachineOut()) {
            args.add("-machine-output");
        }
        for (String excl : this.excludedPaths) {
            args.add(OPT_EXCLUDE);
            args.add(excl);
        }
        this.collectLanguageSpecificTranslationArgs(args);
        if (SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            args.addAll(this.getListWithLauncherArgsRemoved(this.additionalArgs));
        } else {
            args.addAll(this.additionalArgs);
        }
        if (!this.sourcesToScan.isEmpty()) {
            for (String source : this.sourcesToScan) {
                args.add(source);
            }
        }
        return this.printArgs(args);
    }

    protected abstract void collectLanguageSpecificTranslationArgs(List<String> var1);

    public void setExcluded(Collection<String> excluded) {
        this.excludedPaths = excluded != null ? new HashSet<String>(excluded) : Collections.emptySet();
    }

    public Set<String> getSourcesToScan() {
        return this.sourcesToScan;
    }

    public void setSourcesToScan(Collection<String> sourcesToScan) {
        this.sourcesToScan = sourcesToScan != null ? new HashSet<String>(sourcesToScan) : Collections.emptySet();
    }

    @Override
    public List<String> getLauncherArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (!StringUtil.isEmpty(this.sqlType)) {
            args.add(OPT_SQL + this.sqlType);
        }
        if (!SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DISABLE_PREPROCESS_LAUNCHER_ARGS)) {
            args.addAll(this.extractLauncherArgs(this.additionalArgs));
        }
        return args;
    }

    @Override
    public String getArgFilePrefix() {
        return this.projectName + BUILD;
    }

    @Override
    public String getMessage() {
        return "Running translation " + this.projectName;
    }

    @Override
    public void updateMonitor(FortifyProgressMonitor monitor) {
        monitor.startBuild(this.sourcesToScan.size());
    }

    public void setAdditionalArguments(String argsText) {
        if (!StringUtil.isEmpty(argsText)) {
            String[] parsed = StringUtil.parseArguments(argsText);
            this.additionalArgs = Arrays.asList(parsed);
        } else {
            this.additionalArgs = Collections.emptyList();
        }
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public void setSQLType(String type) {
        this.sqlType = type;
    }
}

