/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class Severity {
    static ILogger logger;
    public static final float MIN_SEVERITY_VALUE = 1.0f;
    public static final float MAX_SEVERITY_VALUE = 5.0f;
    public static final String UNKNOWN_SEVERITY = "unknown";
    private static final String DEFAULT_SEVERITY_PROPERTIES = "config/severity.properties";
    private static final Set<SeverityMapping> orderedSeverities;
    private static Properties props;

    private Severity() {
    }

    private static void useDefaultMap() {
        SeverityMapping info = new SeverityMapping("info", new Float(1.0f));
        SeverityMapping low = new SeverityMapping("low", new Float(2.0f));
        SeverityMapping med = new SeverityMapping("medium", new Float(3.0f));
        SeverityMapping high = new SeverityMapping("high", new Float(4.0f));
        SeverityMapping crit = new SeverityMapping("critical", new Float(5.0f));
        orderedSeverities.add(info);
        orderedSeverities.add(low);
        orderedSeverities.add(med);
        orderedSeverities.add(high);
        orderedSeverities.add(crit);
    }

    public static String numberToString(float severityValue) {
        if (severityValue >= 1.0f && severityValue <= 5.0f) {
            for (SeverityMapping sevMap : orderedSeverities) {
                if (!(severityValue <= sevMap.getMaxValue().floatValue())) continue;
                return sevMap.getSeverityName();
            }
        }
        return UNKNOWN_SEVERITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream fis;
        block12: {
            File f;
            logger = MessageManager.getLogger(Severity.class);
            orderedSeverities = new TreeSet<SeverityMapping>();
            props = new Properties();
            String propsFile = System.getProperty("severity.properties.file");
            if (propsFile == null) {
                propsFile = DEFAULT_SEVERITY_PROPERTIES;
            }
            try {
                URL propsURL = Severity.class.getClassLoader().getResource(propsFile);
                f = new File(propsURL.getPath());
            }
            catch (Exception e) {
                f = new File(propsFile);
            }
            fis = null;
            try {
                fis = new FileInputStream(f);
                props.load(fis);
                Enumeration<?> propNames = props.propertyNames();
                if (!propNames.hasMoreElements()) {
                    Severity.useDefaultMap();
                    break block12;
                }
                while (propNames.hasMoreElements()) {
                    String severityName = (String)propNames.nextElement();
                    try {
                        Float severityValue = new Float(props.getProperty(severityName));
                        if (severityValue.floatValue() < 1.0f || severityValue.floatValue() > 5.0f) {
                            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 211, props.getProperty(severityName), severityName);
                            continue;
                        }
                        orderedSeverities.add(new SeverityMapping(severityName, severityValue));
                    }
                    catch (NumberFormatException e) {
                        logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 211, props.getProperty(severityName), severityName);
                    }
                }
            }
            catch (Exception e) {
                try {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Unable to load severity.properties file, using defaults.");
                    Severity.useDefaultMap();
                }
                catch (Throwable throwable) {
                    FileUtil.close(fis);
                    throw throwable;
                }
                FileUtil.close(fis);
            }
        }
        FileUtil.close(fis);
    }

    private static class SeverityMapping
    implements Comparable<SeverityMapping> {
        private String severityName;
        private Float maxValue;

        public SeverityMapping(String severityName, Float minValue) {
            this.severityName = severityName;
            this.maxValue = minValue;
        }

        public String getSeverityName() {
            return this.severityName;
        }

        public Float getMaxValue() {
            return this.maxValue;
        }

        @Override
        public int compareTo(SeverityMapping o) {
            return this.maxValue.compareTo(o.getMaxValue());
        }
    }
}

