/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.exceptions.FortifyException;
import com.fortify.messaging.Message;
import com.fortify.util.Base64;
import com.fortify.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignatureTools {
    private static String ALG = "DSA";
    private static final int KEY_SIZE = 1024;

    public static String sign(String filename, PrivateKey pk) throws IOException, InvalidKeyException, SignatureException {
        return Base64.encode(SignatureTools.sign(FileUtil.loadFileAsBytes(new File(filename)), pk));
    }

    public static byte[] sign(byte[] dataBytes, PrivateKey pk) throws InvalidKeyException, SignatureException, FortifyException {
        try {
            Signature sig = Signature.getInstance(ALG);
            sig.initSign(pk);
            sig.update(dataBytes, 0, dataBytes.length);
            return sig.sign();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FortifyException(new Message(4, 6242, nsae.toString()));
        }
    }

    public static boolean verify(String filename, PublicKey k, String signature) throws IOException, InvalidKeyException, SignatureException {
        return SignatureTools.verify(FileUtil.loadFileAsBytes(new File(filename)), k, Base64.decode(signature));
    }

    public static boolean verify(byte[] dataBytes, PublicKey k, byte[] signature) throws InvalidKeyException, SignatureException, FortifyException {
        try {
            Signature sig = Signature.getInstance(ALG);
            sig.initVerify(k);
            sig.update(dataBytes, 0, dataBytes.length);
            return sig.verify(signature);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FortifyException(new Message(4, 6242, nsae.toString()));
        }
    }

    public static PublicKey getPublicKey(byte[] publicKeyBytes) throws InvalidKeySpecException, FortifyException {
        try {
            X509EncodedKeySpec recoveredKeySpecPublic = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactoryDSA = KeyFactory.getInstance(ALG);
            return keyFactoryDSA.generatePublic(recoveredKeySpecPublic);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FortifyException(new Message(4, 6242, nsae.toString()));
        }
    }

    public static PublicKey getPublicKeyFromFile(String publicKeyFileName) throws FileNotFoundException, IOException, InvalidKeySpecException {
        return SignatureTools.getPublicKey(FileUtil.loadFileAsBytes(new File(publicKeyFileName)));
    }

    public static PublicKey getPublicKeyFromFile(File publicKeyFile) throws FileNotFoundException, IOException, InvalidKeySpecException {
        return SignatureTools.getPublicKey(FileUtil.loadFileAsBytes(publicKeyFile));
    }

    public static PrivateKey getPrivateKey(byte[] privateKeyBytes) throws InvalidKeySpecException, FortifyException {
        try {
            PKCS8EncodedKeySpec recoveredKeySpecPrivate = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory keyFactoryDSA = KeyFactory.getInstance(ALG);
            return keyFactoryDSA.generatePrivate(recoveredKeySpecPrivate);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FortifyException(new Message(4, 6242, nsae.toString()));
        }
    }

    public static PrivateKey getPrivateKeyFromFile(String privateKeyFileName) throws FileNotFoundException, IOException, InvalidKeySpecException {
        return SignatureTools.getPrivateKey(FileUtil.loadFileAsBytes(new File(privateKeyFileName)));
    }

    public static PrivateKey getPrivateKeyFromFile(File privateKeyFile) throws FileNotFoundException, IOException, InvalidKeySpecException {
        return SignatureTools.getPrivateKey(FileUtil.loadFileAsBytes(privateKeyFile));
    }

    public static KeyPair getKeyPairFromFiles(String publicKeyFile, String privateKeyFile) throws IOException, InvalidKeySpecException {
        return new KeyPair(SignatureTools.getPublicKeyFromFile(publicKeyFile), SignatureTools.getPrivateKeyFromFile(privateKeyFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePublicKeyToFile(PublicKey publicKey, String publicKeyName) throws FileNotFoundException, IOException {
        try (FileOutputStream publicKeyFile = new FileOutputStream(publicKeyName);){
            X509EncodedKeySpec encodedKeySpecPublic = new X509EncodedKeySpec(publicKey.getEncoded());
            publicKeyFile.write(encodedKeySpecPublic.getEncoded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePrivateKeyToFile(PrivateKey privateKey, String privateKeyName) throws FileNotFoundException, IOException {
        try (FileOutputStream privateKeyFile = new FileOutputStream(privateKeyName);){
            PKCS8EncodedKeySpec encodedKeySpecPrivate = new PKCS8EncodedKeySpec(privateKey.getEncoded());
            privateKeyFile.write(encodedKeySpecPrivate.getEncoded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateKeysToFiles(String publicKeyName, String privateKeyName) throws FileNotFoundException, IOException {
        FileOutputStream publicKeyFile = new FileOutputStream(publicKeyName);
        FileOutputStream privateKeyFile = new FileOutputStream(privateKeyName);
        try {
            KeyPair keyPair = SignatureTools.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            X509EncodedKeySpec encodedKeySpecPublic = new X509EncodedKeySpec(publicKey.getEncoded());
            PKCS8EncodedKeySpec encodedKeySpecPrivate = new PKCS8EncodedKeySpec(privateKey.getEncoded());
            publicKeyFile.write(encodedKeySpecPublic.getEncoded());
            privateKeyFile.write(encodedKeySpecPrivate.getEncoded());
        }
        finally {
            publicKeyFile.close();
            privateKeyFile.close();
        }
    }

    public static byte[] getPublicKeyBytes(PublicKey publicKey) {
        X509EncodedKeySpec encodedKeySpecPublic = new X509EncodedKeySpec(publicKey.getEncoded());
        return encodedKeySpecPublic.getEncoded();
    }

    public static byte[] getPrivateKeyBytes(PrivateKey privateKey) {
        PKCS8EncodedKeySpec encodedKeySpecPrivate = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return encodedKeySpecPrivate.getEncoded();
    }

    public static KeyPair generateKeyPair() throws FortifyException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALG);
            keyGen.initialize(1024);
            return keyGen.genKeyPair();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FortifyException(new Message(4, 6242, nsae.toString()));
        }
    }

    private static void usage(String[] args) {
        System.out.println("Usage: [options]");
        System.out.println("-g '<public.key> <private.key>'                   Generate key files");
        System.out.println("--generate '<public.filename> <private.filename>'");
        System.out.println("-h, --help, -?                                    Display usage\n");
        System.out.println("\nNOTE:\n\tWhen using keys with rulpack updates, follow the following");
        System.out.println("\tconvention: '<hostname>.public.key' and '<hostname>.private.key'");
    }
}

