/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.DeprecatedPropertyKey;
import com.fortify.util.PropertyKey;
import com.fortify.util.RulepackLocale;
import com.fortify.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.logging.log4j.util.Supplier;

public class SystemUtil {
    static ILogger logger = MessageManager.getLogger(SystemUtil.class);
    private static String localhostName = null;
    private static Properties properties = null;
    public static final String OS_NAME_PROPERTY = "os.name";
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final boolean isWindows;
    private static final boolean isSolaris;
    private static final boolean isMacos;
    private static final boolean isLinux;
    private static final boolean isAIX;
    private static final boolean isHPUX;
    private static final List<RulepackLocale> supportedLocales;
    private static final List<String> supportedLocaleIds;
    private static final List<String> supportedLocaleDisplayNames;
    private static Locale systemDefault;
    private static Locale fortifyLocale;

    public static List<RulepackLocale> getSupportedFortifyLocales() {
        return supportedLocales;
    }

    public static List<String> getSupportedFortifyLocaleIds() {
        return supportedLocaleIds;
    }

    public static List<String> getSupportedFortifyLocaleDisplayNames() {
        return supportedLocaleDisplayNames;
    }

    private SystemUtil() {
    }

    public static String getHostName() throws UnknownHostException {
        if (localhostName == null) {
            localhostName = InetAddress.getLocalHost().getHostName();
        }
        return localhostName;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isMacos() {
        return isMacos;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isAIX() {
        return isAIX;
    }

    public static boolean isHPUX() {
        return isHPUX;
    }

    public static Locale getSystemDefaultLocale() {
        return systemDefault;
    }

    public static Locale getFortifyLocale() {
        if (fortifyLocale == null) {
            fortifyLocale = SystemUtil.determineFortifyLocale();
        }
        return fortifyLocale;
    }

    @Deprecated
    public static void setupDefaultLocale() {
        systemDefault = Locale.getDefault();
        Locale.setDefault(SystemUtil.determineFortifyLocale());
    }

    private static Locale determineFortifyLocale() {
        Locale locale;
        String installLocaleString = SystemUtil.getProperty(CommonPropertyKeys.PK_INSTALL_LOCALE);
        if (installLocaleString == null) {
            return Locale.getDefault();
        }
        StringTokenizer st = new StringTokenizer(installLocaleString, "_");
        String language = st.nextToken();
        if (st.hasMoreTokens()) {
            String country = st.nextToken();
            if (st.hasMoreTokens()) {
                String variant = st.nextToken();
                locale = new Locale(language, country, variant);
            } else {
                locale = new Locale(language, country);
            }
        } else {
            locale = new Locale(language, "");
        }
        return locale;
    }

    public static InputStream getLocalResourceAsStream(String resourceName) {
        return SystemUtil.getLocalResourceAsStream(resourceName, SystemUtil.getFortifyLocale(), SystemUtil.class.getClassLoader());
    }

    public static InputStream getLocalResourceAsStream(String resourceName, Locale locale) {
        return SystemUtil.getLocalResourceAsStream(resourceName, locale, SystemUtil.class.getClassLoader());
    }

    public static InputStream getLocalResourceAsStream(String resourceName, Locale locale, ClassLoader cl) {
        InputStream result = cl.getResourceAsStream(resourceName + SystemUtil.getLocaleSuffix(locale));
        if (result != null) {
            return result;
        }
        return cl.getResourceAsStream(resourceName);
    }

    public static String getLocaleString(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (language != null && language.length() > 0) {
            if (country != null && country.length() > 0) {
                if (variant != null && variant.length() > 0) {
                    return language + "_" + country + "_" + variant;
                }
                return language + "_" + country;
            }
            return language;
        }
        return "";
    }

    public static String getLocaleSuffix(Locale locale) {
        String localeString = SystemUtil.getLocaleString(locale);
        if ("".equals(localeString)) {
            return "";
        }
        return "_" + localeString;
    }

    public static String getLocaleSuffix() {
        String localeString = SystemUtil.getLocaleString(SystemUtil.getFortifyLocale());
        if ("".equals(localeString)) {
            return "";
        }
        return "_" + localeString;
    }

    public static Properties getProperties() {
        if (properties == null) {
            SystemUtil.loadCommonProperties();
        }
        return properties;
    }

    public static void validateProperties(ArrayList<Field> fieldsProperties, String limiterBase, Field[] fieldsLimiters, List<String> exceptions, Properties props) {
        HashSet<Object> keysSnapshot = new HashSet<Object>(props.keySet());
        int l = limiterBase.length();
        block4: for (Object e : keysSnapshot) {
            String property;
            if (!(e instanceof String) || !(property = (String)e).startsWith("com.fortify") || property.startsWith("com.fortify.sca.rules.")) continue;
            for (Field field : fieldsProperties) {
                try {
                    String name;
                    Object obj = field.get(null);
                    if (!(obj instanceof PropertyKey) || !property.equals(name = ((PropertyKey)obj).key)) continue;
                    if (!(obj instanceof DeprecatedPropertyKey)) continue block4;
                    ((DeprecatedPropertyKey)obj).warn();
                    continue block4;
                }
                catch (IllegalAccessException obj) {
                }
            }
            int p = property.length();
            if (p > l && property.startsWith(limiterBase)) {
                for (Field field : fieldsLimiters) {
                    try {
                        Object obj = field.get(null);
                        if (!(obj instanceof Integer)) continue;
                        String name = field.getName();
                        if (!property.substring(l + 1).equals(name)) continue;
                        continue block4;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            } else {
                for (String string : exceptions) {
                    if (!property.startsWith(string)) continue;
                    continue block4;
                }
            }
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 242, property);
        }
    }

    public static void validateProperties(ArrayList<Field> fieldsProperties, String limiterBase, Field[] fieldsLimiters, List<String> exceptions) {
        SystemUtil.validateProperties(fieldsProperties, limiterBase, fieldsLimiters, exceptions, SystemUtil.getProperties());
    }

    public static void validateProperties(ArrayList<Field> fieldsProperties, List<String> exceptions) {
        SystemUtil.validateProperties(fieldsProperties, "|", new Field[0], exceptions, SystemUtil.getProperties());
    }

    public static String getProperty(PropertyKey key) {
        return SystemUtil.getProperties().getProperty(key.key);
    }

    public static void setInstallRoot() {
        URL selfUrl = SystemUtil.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File installDir = new File(selfUrl.toURI()).getParentFile().getParentFile().getParentFile();
            System.setProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT.key, installDir.getPath());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadCommonProperties() {
        properties = new Properties(System.getProperties());
        String installRoot = System.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT.key);
        if (installRoot == null) {
            throw new IllegalStateException(CommonPropertyKeys.PK_FORTIFY_INST_ROOT.key + " not set");
        }
        String core = System.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE.key);
        if (core == null) {
            core = new File(installRoot, "Core").getAbsolutePath();
            properties.setProperty(CommonPropertyKeys.PK_FORTIFY_CORE.key, core);
        }
        try {
            SystemUtil.loadPropertiesFromFile(properties, new File(core, "config/fortify.properties"), false);
        }
        catch (IOException ioe) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 207, (Throwable)ioe, new Supplier[0]);
        }
        File userPropFile = new File(System.getProperty("user.home"), SystemUtil.isWindows() ? "fortify.properties" : ".fortify.properties");
        if (userPropFile.exists()) {
            try {
                SystemUtil.loadPropertiesFromFile(properties, userPropFile, true);
            }
            catch (IOException ioe) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 207, (Throwable)ioe, userPropFile.getAbsolutePath());
            }
        }
    }

    @Deprecated
    public static void loadProperties(Properties existing, String bundleName) {
        SystemUtil.loadPropertiesFromResource(existing, bundleName, false);
    }

    public static void loadPropertiesFromResource(Properties existing, String bundleName, boolean replace) {
        ResourceBundle res = ResourceBundle.getBundle(bundleName);
        Enumeration<String> keys = res.getKeys();
        Properties newProps = new Properties();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            newProps.setProperty(key, res.getString(key));
        }
        SystemUtil.mergeProperties(existing, newProps, replace);
    }

    @Deprecated
    public static void loadProperties(Properties existing, File file) throws IOException {
        SystemUtil.loadPropertiesFromFile(existing, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPropertiesFromFile(Properties existing, File file, boolean replace) throws IOException {
        Properties newProps = new Properties();
        try (FileInputStream inStream = null;){
            inStream = new FileInputStream(file);
            newProps.load(inStream);
            SystemUtil.mergeProperties(existing, newProps, replace);
        }
    }

    private static void mergeProperties(Properties existing, Properties toMerge, boolean replace) {
        for (String string : toMerge.keySet()) {
            if (!replace && existing.containsKey(string)) continue;
            String propVal = SystemUtil.replaceVarsInProp(toMerge.getProperty(string), replace ? toMerge : existing, replace ? existing : toMerge);
            existing.setProperty(string, propVal);
        }
    }

    public static String replaceVarsInProp(String prop, Properties primary, Properties secondary) {
        return SystemUtil.replaceVarsInProp(prop, primary, secondary, 0);
    }

    private static String replaceVarsInProp(String prop, Properties primary, Properties secondary, int recurse) {
        if (recurse > 5) {
            return prop;
        }
        StringBuffer eb = new StringBuffer();
        char[] chars = prop.toCharArray();
        int seq = 0;
        int keyStart = -1;
        for (int i = 1; i < chars.length; ++i) {
            if (keyStart < 0) {
                if (chars[i - 1] != '$' || chars[i] != '{') continue;
                keyStart = i + 1;
                continue;
            }
            if (chars[i] != '}') continue;
            eb.append(chars, seq, keyStart - 2 - seq);
            String propKey = String.valueOf(chars, keyStart, i - keyStart);
            String propVal = primary.getProperty(propKey);
            if (propVal == null || propVal == prop) {
                propVal = secondary.getProperty(propKey);
            }
            if (propVal == null) {
                int defaultIndex = propKey.indexOf(":-");
                if (defaultIndex != -1) {
                    eb.append(propKey.substring(defaultIndex + 2));
                } else {
                    eb.append("${").append(propKey).append("}");
                }
            } else {
                eb.append(SystemUtil.replaceVarsInProp(propVal, primary, secondary, recurse + 1));
            }
            seq = i + 1;
            keyStart = -1;
        }
        if (seq < chars.length) {
            eb.append(chars, seq, chars.length - seq);
        }
        return eb.toString();
    }

    public static File findExecutableDir(String pathList, String name) {
        if (pathList == null) {
            return null;
        }
        List<String> paths = StringUtil.split(pathList, File.pathSeparatorChar);
        return SystemUtil.findExecutableDir(paths.toArray(new String[0]), name);
    }

    public static void reassessVariableSubstitution() {
        for (String string : properties.keySet()) {
            String newVal;
            String oldVal = properties.getProperty(string);
            if (oldVal.equals(newVal = SystemUtil.replaceVarsInProp(oldVal, properties, properties))) continue;
            properties.setProperty(string, newVal);
        }
    }

    public static File findExecutableDir(String[] pathList, String name) {
        if (pathList == null) {
            return null;
        }
        String nameLower = name.toLowerCase();
        String[] nameCheck = SystemUtil.isWindows() && !nameLower.endsWith(".com") && !nameLower.endsWith(".exe") && !nameLower.endsWith(".bat") && !nameLower.endsWith(".cmd") ? new String[]{name + ".com", name + ".exe", name + ".bat", name + ".cmd"} : new String[]{name};
        for (int i = 0; i < pathList.length; ++i) {
            for (int j = 0; j < nameCheck.length; ++j) {
                String nameTry = nameCheck[j];
                String path = pathList[i];
                File f = new File(path, nameTry);
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ex) {
                    continue;
                }
                if (!f.isFile()) continue;
                return f.getParentFile();
            }
        }
        return null;
    }

    public static String getProperty(PropertyKey propertyName, String defaultValue) {
        String ret = SystemUtil.getProperty(propertyName);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean getBooleanProperty(PropertyKey propertyName) {
        return SystemUtil.getBooleanProperty(propertyName, false);
    }

    public static boolean getBooleanProperty(PropertyKey propertyName, boolean defaultValue) {
        String ret = SystemUtil.getProperty(propertyName);
        if (ret == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(ret);
    }

    public static Integer getIntegerProperty(PropertyKey propertyName) {
        String ret = SystemUtil.getProperty(propertyName);
        if (ret == null) {
            return null;
        }
        try {
            return Integer.valueOf(ret);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static int getMaxFileLength() {
        Integer maxLength = SystemUtil.getIntegerProperty(CommonPropertyKeys.MAX_FILE_PATH_LENGTH);
        if (maxLength == null) {
            return 255;
        }
        return maxLength;
    }

    static {
        supportedLocales = Collections.unmodifiableList(Arrays.asList(RulepackLocale.ENGLISH, RulepackLocale.JAPANESE, RulepackLocale.KOREAN, RulepackLocale.SIMPLIFIED_CHINESE, RulepackLocale.TRADITIONAL_CHINESE, RulepackLocale.SPANISH, RulepackLocale.PORTUGUESE));
        String osname = System.getProperty(OS_NAME_PROPERTY).toLowerCase();
        isWindows = osname.indexOf("windows") != -1;
        isSolaris = osname.indexOf("sunos") != -1 || osname.indexOf("solaris") != -1;
        isMacos = osname.indexOf("mac") != -1;
        isLinux = osname.indexOf("linux") != -1;
        isAIX = osname.indexOf("aix") != -1;
        isHPUX = osname.indexOf("hp-ux") != -1;
        ArrayList<String> localeIds = new ArrayList<String>();
        for (RulepackLocale locale : supportedLocales) {
            localeIds.add(locale.getLocaleId());
        }
        supportedLocaleIds = Collections.unmodifiableList(localeIds);
        ArrayList<String> localeDisplayNames = new ArrayList<String>();
        for (RulepackLocale locale : supportedLocales) {
            localeDisplayNames.add(locale.getDisplayName());
        }
        supportedLocaleDisplayNames = Collections.unmodifiableList(localeDisplayNames);
        systemDefault = Locale.getDefault();
    }
}

