/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.Util;
import java.io.Serializable;
import java.util.Iterator;

public final class Triple<A, B, C>
implements Serializable {
    public final A first;
    public final B second;
    public final C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> mk(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }

    public boolean equals(Object other) {
        if (!(other instanceof Triple)) {
            return false;
        }
        return this.equals((Triple)other);
    }

    public boolean equals(Triple<A, B, C> other) {
        return Util.eq(this.first, other.first) && Util.eq(this.second, other.second) && Util.eq(this.third, other.third);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.first != null) {
            hashCode ^= this.first.hashCode();
        }
        if (this.second != null) {
            hashCode ^= this.second.hashCode();
        }
        if (this.third != null) {
            hashCode ^= this.third.hashCode();
        }
        return hashCode;
    }

    public static <A, B, C> Iterator<A> firstIterator(final Iterator<Triple<A, B, C>> it) {
        return new Iterator<A>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public A next() {
                return ((Triple)it.next()).first;
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static <A, B, C> Iterator<B> secondIterator(final Iterator<Triple<A, B, C>> it) {
        return new Iterator<B>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public B next() {
                return ((Triple)it.next()).second;
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static <A, B, C> Iterator<C> thirdIterator(final Iterator<Triple<A, B, C>> it) {
        return new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public C next() {
                return ((Triple)it.next()).third;
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }
}

