/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.ergy.fset.FMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class Util {
    private Util() {
    }

    public static SAXParser createSaxParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spFactory = SAXParserFactory.newInstance();
        Util.saxSetFeature(spFactory, "http://xml.org/sax/features/resolve-dtd-uris", false);
        Util.saxSetFeature(spFactory, "http://xml.org/sax/features/validation", false);
        Util.saxSetFeature(spFactory, "http://xml.org/sax/features/external-general-entities", false);
        Util.saxSetFeature(spFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        Util.saxSetFeature(spFactory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        Util.saxSetFeature(spFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spFactory.setValidating(false);
        SAXParser sp = spFactory.newSAXParser();
        return sp;
    }

    private static void saxSetFeature(SAXParserFactory pf, String feature, boolean value) {
        try {
            pf.setFeature(feature, value);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    public static <T> boolean eq(T a, T b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Object[]) {
            if (b instanceof Object[]) {
                return Arrays.equals((Object[])a, (Object[])b);
            }
            return false;
        }
        return a.equals(b);
    }

    public static <T, K extends T> int compare(Comparable<T> a, K b) {
        return Util.compare(a, b, 1);
    }

    public static <T, K extends T> int compare(Comparable<T> a, K b, IntFunc<Comparable<T>, K> cont) {
        int res = Util.compare(a, b, 1);
        if (res != 0) {
            return res;
        }
        return cont.apply(a, b);
    }

    public static <T, K extends T> int compare(Comparable<T> a, K b, int bias) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return bias;
        }
        if (b == null) {
            return -bias;
        }
        return a.compareTo(b);
    }

    public static <S, T extends Comparable<S>, K extends S> int compare(List<T> a, List<K> b, int bias, boolean preferShorter) {
        int sizDif;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return bias;
        }
        if (b == null) {
            return -bias;
        }
        if (preferShorter && (sizDif = a.size() - b.size()) != 0) {
            return sizDif;
        }
        Iterator<T> aIterator = a.iterator();
        Iterator<K> bIterator = b.iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            int elemComp = Util.compare((Comparable)aIterator.next(), bIterator.next(), bias);
            if (elemComp == 0) continue;
            return elemComp;
        }
        if (aIterator.hasNext()) {
            return bias;
        }
        if (bIterator.hasNext()) {
            return -bias;
        }
        return 0;
    }

    @Deprecated
    public static <S, A extends Comparable<S>, B extends S> int compare(A[] a, B[] b, int bias, boolean preferShorter) {
        int i;
        int sizDif;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return bias;
        }
        if (b == null) {
            return -bias;
        }
        if (preferShorter && (sizDif = a.length - b.length) != 0) {
            return sizDif;
        }
        for (i = 0; i < a.length && i < b.length; ++i) {
            int elemCmp = Util.compare(a[i], b[i], bias);
            if (elemCmp == 0) continue;
            return elemCmp;
        }
        if (i < a.length) {
            return bias;
        }
        if (i < b.length) {
            return -bias;
        }
        return 0;
    }

    public static <Base, A extends Comparable<Base>, B extends Base> int compare(LinkedHashSet<A> a, LinkedHashSet<B> b, int bias, boolean preferShorter) {
        int sizDif;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return bias;
        }
        if (b == null) {
            return -bias;
        }
        if (preferShorter && (sizDif = a.size() - b.size()) != 0) {
            return sizDif;
        }
        Iterator aIterator = a.iterator();
        Iterator bIterator = b.iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            int elemComp = Util.compare((Comparable)aIterator.next(), bIterator.next(), bias);
            if (elemComp == 0) continue;
            return elemComp;
        }
        if (aIterator.hasNext()) {
            return bias;
        }
        if (bIterator.hasNext()) {
            return -bias;
        }
        return 0;
    }

    public static <KeyBase, KeyA extends Comparable<KeyBase>, KeyB extends KeyBase, ValBase, ValA extends Comparable<ValBase>, ValB extends ValBase> int compare(LinkedHashMap<KeyA, ValA> a, LinkedHashMap<KeyB, ValB> b, int bias, boolean preferShorter) {
        return Util.compareOrderedMap(a, b, bias, preferShorter);
    }

    public static <KeyBase, KeyA extends Comparable<KeyBase>, KeyB extends KeyBase, ValBase, ValA extends Comparable<ValBase>, ValB extends ValBase> int compare(FMap<KeyA, ValA> a, FMap<KeyB, ValB> b, int bias, boolean preferShorter) {
        return Util.compareOrderedMap(a, b, bias, preferShorter);
    }

    private static <KeyBase, KeyA extends Comparable<KeyBase>, KeyB extends KeyBase, ValBase, ValA extends Comparable<ValBase>, ValB extends ValBase> int compareOrderedMap(Map<KeyA, ValA> a, Map<KeyB, ValB> b, int bias, boolean preferShorter) {
        int sizDif;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return bias;
        }
        if (b == null) {
            return -bias;
        }
        if (preferShorter && (sizDif = a.size() - b.size()) != 0) {
            return sizDif;
        }
        Iterator<Map.Entry<KeyA, ValA>> aIterator = a.entrySet().iterator();
        Iterator<Map.Entry<KeyB, ValB>> bIterator = b.entrySet().iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            Map.Entry<KeyA, ValA> elemA = aIterator.next();
            Map.Entry<KeyB, ValB> elemB = bIterator.next();
            int keyCmp = Util.compare((Comparable)elemA.getKey(), elemB.getKey(), bias);
            if (keyCmp != 0) {
                return keyCmp;
            }
            int valCmp = Util.compare((Comparable)elemA.getValue(), elemB.getValue(), bias);
            if (valCmp == 0) continue;
            return valCmp;
        }
        if (aIterator.hasNext()) {
            return bias;
        }
        if (bIterator.hasNext()) {
            return -bias;
        }
        return 0;
    }

    public static <T, R> R cast(T value) {
        return (R)value;
    }

    public static AssertionError badType(Object o) {
        return new AssertionError((Object)("Unhandled type: " + Util.getTypeString(o)));
    }

    public static void assertBadType(Object o) {
        assert (false) : "Unhandled type: " + Util.getTypeString(o);
    }

    private static String getTypeString(Object o) {
        if (o == null) {
            return "<null>";
        }
        return o.getClass().getName();
    }

    public static Pattern literalRegex(String s) {
        return Pattern.compile(Pattern.quote(s));
    }

    public static AssertionError assertRelay(String message, Throwable cause) {
        AssertionError a = new AssertionError((Object)message);
        ((Throwable)((Object)a)).initCause(cause);
        return a;
    }

    public static void ensureNotNull(Object ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
    }

    public static void ensureNotNull(Object ref, String name) {
        if (ref == null) {
            throw new NullPointerException(name);
        }
    }

    public static void ensureNotNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be positive");
        }
    }

    public static void ensureNotNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException("'" + name + "' must not be negative");
        }
    }

    public static void ensurePositive(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("value must be positive");
        }
    }

    public static void ensurePositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException("'" + name + "' must be positive");
        }
    }

    public static <T> T[] concat(T[] a, T[] b) {
        Object[] copy = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, copy, 0, a.length);
        System.arraycopy(b, 0, copy, a.length, b.length);
        return copy;
    }

    public static <T> T[] subArray(T[] a, int start, int end) {
        int length = end - start;
        if (end < 0 || start < 0 || end > a.length || length < 0) {
            throw new IllegalArgumentException("start = " + start + ", end = " + end);
        }
        if (length == a.length) {
            return a;
        }
        Object[] copy = (Object[])Array.newInstance(a.getClass().getComponentType(), length);
        System.arraycopy(a, start, copy, 0, length);
        return copy;
    }

    public static <T> T[] shrinkArray(T[] a, int size) {
        assert (a != null);
        if (a.length == size) {
            return a;
        }
        if (a.length < size) {
            throw new IllegalArgumentException("a.length < size, a.length = " + a.length + ", size = " + size);
        }
        Object[] na = (Object[])Util.cast(Array.newInstance(a.getClass().getComponentType(), size));
        System.arraycopy(a, 0, na, 0, size);
        return na;
    }

    public static <T> Map<T, T> mapify(T[] list) {
        return Util.mapify(list, new HashMap());
    }

    public static <T> Map<T, T> mapify(T[] list, Map<T, T> map) {
        if ((list.length & 1) == 1) {
            throw new IllegalArgumentException("Must pass even-size array (" + list.length + ")");
        }
        for (int i = 0; i < list.length; i += 2) {
            map.put(list[i], list[i + 1]);
        }
        return map;
    }

    public static <T> T[] L(T ... list) {
        return list;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.size() == 0;
    }

    public static interface IntFunc<T, U> {
        public int apply(T var1, U var2);
    }
}

