/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.IndentPrinter;
import com.fortify.util.SystemUtil;
import com.fortify.util.Util;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

public class VmMonitor {
    static ILogger logger = MessageManager.getLogger(VmMonitor.class);

    public static boolean disableMxData() {
        String value = SystemUtil.getProperty(CommonPropertyKeys.PK_DISABLE_MX_DATA);
        return value != null && !"false".equalsIgnoreCase(value);
    }

    private static boolean printFullMxData() {
        String value = SystemUtil.getProperty(CommonPropertyKeys.PK_FULL_MX_DATA);
        return value != null && !"false".equalsIgnoreCase(value);
    }

    public static String printMXBeans(EnumSet<MXBeanType> include) {
        StringWriter sw = new StringWriter();
        VmMonitor.printMXBeans(include, sw);
        return sw.toString();
    }

    public static void printMXBeans(EnumSet<MXBeanType> include, Writer out) {
        if (VmMonitor.disableMxData()) {
            return;
        }
        IndentPrinter ip = new IndentPrinter(out);
        VmMonitor.writeMXBean(include, MXBeanType.ClassLoading, ManagementFactory.getClassLoadingMXBean(), ClassLoadingMXBean.class, ip);
        VmMonitor.writeMXBean(include, MXBeanType.Compilation, ManagementFactory.getCompilationMXBean(), CompilationMXBean.class, ip);
        VmMonitor.writeMXBeanList(include, MXBeanType.GarbageCollector, ManagementFactory.getGarbageCollectorMXBeans(), GarbageCollectorMXBean.class, ip);
        VmMonitor.writeMXBeanList(include, MXBeanType.MemoryManager, ManagementFactory.getMemoryManagerMXBeans(), MemoryManagerMXBean.class, ip);
        VmMonitor.writeMXBean(include, MXBeanType.Memory, ManagementFactory.getMemoryMXBean(), MemoryMXBean.class, ip);
        VmMonitor.writeMXBeanList(include, MXBeanType.MemoryPool, ManagementFactory.getMemoryPoolMXBeans(), MemoryPoolMXBean.class, ip);
        VmMonitor.writeMXBean(include, MXBeanType.OperatingSystem, ManagementFactory.getOperatingSystemMXBean(), OperatingSystemMXBean.class, ip);
        VmMonitor.writeMXBean(include, MXBeanType.Runtime, ManagementFactory.getRuntimeMXBean(), RuntimeMXBean.class, ip);
        VmMonitor.writeMXBean(include, MXBeanType.Thread, ManagementFactory.getThreadMXBean(), ThreadMXBean.class, ip);
        ip.flush();
    }

    private static <T> void writeMXBeanList(EnumSet<MXBeanType> include, MXBeanType actual, List<T> mxBeans, Class<T> mxInterface, IndentPrinter ip) {
        if (!include.contains((Object)actual)) {
            return;
        }
        ip.println("[" + mxInterface.getSimpleName() + "s]");
        ip.indent();
        for (T mxBean : mxBeans) {
            VmMonitor.writeMXBean(include, actual, mxBean, mxInterface, ip);
        }
        ip.dedent();
    }

    private static <T> void writeMXBean(EnumSet<MXBeanType> include, MXBeanType actual, T mxBean, Class<T> mxInterface, IndentPrinter ip) {
        if (!include.contains((Object)actual)) {
            return;
        }
        if (mxBean == null) {
            return;
        }
        boolean fullData = VmMonitor.printFullMxData();
        ip.print(mxInterface.getSimpleName() + ": ");
        Map<String, String> beanContents = VmMonitor.listBean(mxBean);
        if (beanContents.containsKey("Name")) {
            String n = beanContents.remove("Name");
            ip.print(n);
        }
        if (!fullData) {
            beanContents.keySet().removeAll(actual.getExcludedStrings());
        }
        ip.println();
        ip.indent();
        ArrayList<String> keys = new ArrayList<String>(beanContents.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            ip.println(key + ": " + beanContents.get(key));
        }
        if (mxBean instanceof ThreadMXBean) {
            ThreadMXBean tmxb = (ThreadMXBean)Util.cast(mxBean);
            for (long tid : tmxb.getAllThreadIds()) {
                ThreadInfo ti = tmxb.getThreadInfo(tid, 0);
                if (ti == null) continue;
                ip.println("Thread " + tid + " [" + ti.getThreadName() + "]");
                ip.indent();
                try {
                    ip.println("ThreadCpuTime: " + tmxb.getThreadCpuTime(tid));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ip.println("ThreadUserTime: " + tmxb.getThreadUserTime(tid));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (fullData) {
                    Map<String, String> tiContents = VmMonitor.listBean(ti);
                    tiContents.remove("ThreadName");
                    ArrayList<String> tikeys = new ArrayList<String>(tiContents.keySet());
                    Collections.sort(tikeys);
                    for (String key : tikeys) {
                        ip.println(key + ": " + tiContents.get(key));
                    }
                }
                ip.dedent();
            }
        }
        ip.dedent();
    }

    public static void main(String[] args) {
        System.out.println(VmMonitor.printMXBeans(EnumSet.allOf(MXBeanType.class)));
    }

    private static void storeAttribute(Map<String, String> data, String name, Object value) {
        if (value == null) {
            return;
        }
        Class<?> rt = value.getClass();
        if (rt.isPrimitive() || VmMonitor.isPrintableType(rt)) {
            data.put(name, value.toString());
        } else if (rt.isArray()) {
            Class<?> ct = rt.getComponentType();
            String valString = null;
            if (VmMonitor.isPrintableType(ct)) {
                Object[] val = (Object[])value;
                valString = Arrays.toString(val);
            } else if (ct == Long.TYPE) {
                long[] val = (long[])value;
                valString = Arrays.toString(val);
            } else if (ct == Integer.TYPE) {
                int[] val = (int[])value;
                valString = Arrays.toString(val);
            } else if (ct == Boolean.TYPE) {
                boolean[] val = (boolean[])value;
                valString = Arrays.toString(val);
            } else if (ct == Short.TYPE) {
                short[] val = (short[])value;
                valString = Arrays.toString(val);
            } else if (ct == Character.TYPE) {
                char[] val = (char[])value;
                valString = Arrays.toString(val);
            } else if (ct == Byte.TYPE) {
                byte[] val = (byte[])value;
                valString = Arrays.toString(val);
            } else if (ct == Double.TYPE) {
                double[] val = (double[])value;
                valString = Arrays.toString(val);
            } else if (ct == Float.TYPE) {
                float[] val = (float[])value;
                valString = Arrays.toString(val);
            }
            if (valString != null) {
                data.put(name, valString);
            }
        } else if (value instanceof CompositeData) {
            CompositeData cd = (CompositeData)value;
            CompositeType ct = cd.getCompositeType();
            StringBuilder sb = new StringBuilder();
            for (String k : ct.keySet()) {
                String sk;
                Object v;
                if (!(k instanceof String) || (v = cd.get(sk = k)) == null || !VmMonitor.isPrintableType(v.getClass())) continue;
                sb.append(sk);
                sb.append(" = ");
                sb.append(v.toString());
                sb.append(' ');
            }
            if (sb.length() > 0) {
                data.put(name, sb.toString());
            }
        }
    }

    private static Map<String, String> listBean(Object mxBean) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (mxBean instanceof DynamicMBean) {
            DynamicMBean dmxBean = (DynamicMBean)Util.cast(mxBean);
            MBeanInfo mbi = dmxBean.getMBeanInfo();
            for (MBeanAttributeInfo mBeanAttributeInfo : mbi.getAttributes()) {
                try {
                    VmMonitor.storeAttribute(result, mBeanAttributeInfo.getName(), dmxBean.getAttribute(mBeanAttributeInfo.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            Class<?> mxClass = mxBean.getClass();
            Class<Object>[] mxClassUse = !Modifier.isPublic(mxClass.getModifiers()) ? mxClass.getInterfaces() : Util.L(mxClass);
            for (Class<?> clazz : mxClassUse) {
                for (Method m : clazz.getMethods()) {
                    String key;
                    if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers()) || result.containsKey(key = m.getName().substring(m.getName().startsWith("is") ? 2 : 3))) continue;
                    VmMonitor.storeAttribute(result, key, VmMonitor.runGetter(mxBean, m));
                }
            }
        }
        return result;
    }

    private static boolean isPrintableType(Class c) {
        return c == String.class || c == MemoryType.class || c == MemoryUsage.class || c == Integer.class || c == Long.class || c == Short.class || c == Byte.class || c == Double.class || c == Float.class || c == Character.class || c == Boolean.class;
    }

    private static Object runGetter(Object mxBean, Method getter) {
        try {
            return getter.invoke(mxBean, new Object[0]);
        }
        catch (IllegalAccessException ie) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unexpected exception invoking method " + getter, (Throwable)ie);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private VmMonitor() {
    }

    public static enum MXBeanType {
        ClassLoading(new String[0]),
        Compilation(new String[0]),
        GarbageCollector(new String[0]),
        MemoryManager(new String[0]),
        Memory(new String[0]),
        MemoryPool("CollectionUsageThresholdSupported", "UsageThresholdSupported", "Valid"),
        OperatingSystem(new String[0]),
        Runtime(new String[0]),
        Thread("AllThreadIds", "CurrentThreadCpuTimeSupported", "ThreadContentionMonitoringEnabled", "ThreadContentionMonitoringSupported", "ThreadCpuTimeEnabled", "ThreadCpuTimeSupported");

        private final Set<String> excludedKeys;

        private MXBeanType(String ... excludedKeys) {
            this.excludedKeys = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(excludedKeys)));
        }

        public Set<String> getExcludedStrings() {
            return this.excludedKeys;
        }
    }
}

