/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.ZipUtil;
import com.fortify.util.filevisitor.RecursiveFileVisitor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WebappValidator {
    static ILogger logger = MessageManager.getLogger(WebappValidator.class);
    private String sep;
    private ZipFile zipFile = null;
    private File webapp = null;
    private boolean isZip = false;
    private boolean isDirectory = false;
    private String webInf = null;
    private boolean hasWebXML = false;

    public boolean exists() {
        return this.isZip || this.isDirectory;
    }

    public boolean isZip() {
        return this.isZip;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getWebInf() {
        return this.webInf;
    }

    public boolean hasWebXML() {
        return this.hasWebXML;
    }

    public WebappValidator(File webapp) {
        if (!webapp.exists()) {
            logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 101, webapp.getAbsolutePath());
            return;
        }
        this.webapp = webapp;
        this.isZip = ZipUtil.isZip(webapp);
        if (this.isZip) {
            try {
                this.zipFile = new ZipFile(webapp);
            }
            catch (IOException e) {
                logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 241, webapp.getAbsolutePath(), e);
                this.zipFile = null;
                return;
            }
            this.sep = "/";
        } else {
            this.sep = File.separator;
        }
        this.isDirectory = webapp.isDirectory();
        this.webInf = this.findFile("WEB-INF");
        String webXml = this.findFile("WEB-INF" + this.sep + "web.xml");
        if (webXml != null) {
            this.hasWebXML = true;
        }
    }

    public String findFile(String fileToFind) {
        ZipEntry zipEntry;
        final String theFile = fileToFind;
        final ArrayList matches = new ArrayList();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getPath().endsWith(theFile);
            }
        };
        if (this.isDirectory) {
            RecursiveFileVisitor visitor = new RecursiveFileVisitor(){

                @Override
                protected void process(File file) {
                    matches.add(file.getPath());
                }
            };
            visitor.traverse(this.webapp, filter);
            if (matches.size() != 0) {
                return (String)matches.get(0);
            }
        } else if (this.isZip && (zipEntry = ZipUtil.getEntryEndingWith(this.zipFile, fileToFind)) != null) {
            return zipEntry.getName();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: WebappValidator <path>");
            return;
        }
        File webapp = new File(args[0]);
        WebappValidator webVal = new WebappValidator(webapp);
        if (!webVal.isZip() && !webVal.isDirectory()) {
            System.out.println("Invalid file: " + webapp.getAbsolutePath());
            return;
        }
        System.out.println("Checking archive for WEB-INF: " + webVal.getWebInf());
        System.out.println("Checking archive has WEB-INF/web.xml: " + webVal.hasWebXML());
    }
}

