/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

public class WindowsArgProtector {
    private WindowsArgProtector() {
    }

    public static String quotePath(String arg) {
        int guessCapacity = arg.length() + 2 + 5;
        StringBuffer buf = new StringBuffer(guessCapacity);
        WindowsArgProtector.quote(buf, arg, true);
        return buf.toString();
    }

    public static String quote(String arg) {
        int guessCapacity = arg.length() + 2 + 5;
        StringBuffer buf = new StringBuffer(guessCapacity);
        WindowsArgProtector.quote(buf, arg);
        return buf.toString();
    }

    public static void quote(StringBuffer buf, String arg) {
        WindowsArgProtector.quote(buf, arg, false);
    }

    public static void quote(StringBuffer buf, String arg, boolean escapeBackslash) {
        int nPending = 0;
        buf.append('\"');
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c == '\\') {
                ++nPending;
            } else {
                int j;
                if (c == '\"') {
                    for (j = 0; j < nPending + 1; ++j) {
                        buf.append('\\');
                    }
                } else if (escapeBackslash) {
                    for (j = 0; j < nPending; ++j) {
                        buf.append('\\');
                    }
                }
                nPending = 0;
            }
            buf.append(c);
        }
        for (int j = 0; j < nPending; ++j) {
            buf.append('\\');
        }
        buf.append('\"');
    }

    public static int calcEscapes(String arg) {
        return WindowsArgProtector.calcEscapes(arg, false);
    }

    public static int calcEscapes(String arg, boolean quoteMetaChars) {
        boolean needsQuotes = false;
        int nPending = 0;
        int nTotalEsc = 0;
        boolean insideQuoted = false;
        boolean pendingToBeQuoted = false;
        block5: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\\': {
                    ++nPending;
                    continue block5;
                }
                case '\"': {
                    insideQuoted = !insideQuoted;
                    pendingToBeQuoted = false;
                    nTotalEsc += nPending + 1;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    pendingToBeQuoted = insideQuoted;
                    needsQuotes = needsQuotes || !insideQuoted;
                    continue block5;
                }
                default: {
                    if (quoteMetaChars && WindowsArgProtector.isShellMetachar(c)) {
                        needsQuotes = !insideQuoted;
                    }
                    nPending = 0;
                }
            }
        }
        if (insideQuoted && pendingToBeQuoted) {
            return nTotalEsc;
        }
        if (!needsQuotes) {
            return -1;
        }
        return nTotalEsc += nPending;
    }

    private static boolean isShellMetachar(char c) {
        switch (c) {
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case ';': 
            case '<': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static String quoteMaybe(String arg) {
        StringBuffer buf = new StringBuffer(arg.length());
        WindowsArgProtector.quoteMaybe(buf, arg);
        return buf.toString();
    }

    public static void quoteMaybe(StringBuffer buf, String arg) {
        WindowsArgProtector.quoteMaybe(buf, arg, false);
    }

    public static void quoteMaybeMeta(StringBuffer buf, String arg) {
        WindowsArgProtector.quoteMaybe(buf, arg, true);
    }

    private static void quoteMaybe(StringBuffer buf, String arg, boolean quoteShellMetaChars) {
        if (arg.length() == 0) {
            buf.append("\"\"");
            return;
        }
        switch (WindowsArgProtector.calcEscapes(arg, quoteShellMetaChars)) {
            case -1: {
                buf.append(arg);
                break;
            }
            case 0: {
                buf.append('\"').append(arg).append('\"');
                break;
            }
            default: {
                WindowsArgProtector.quote(buf, arg);
            }
        }
    }

    public static void main(String[] args) {
        int failed = 0;
        failed += WindowsArgProtector.check("\"\"", WindowsArgProtector.quote(""), "quote") ? 0 : 1;
        failed += WindowsArgProtector.check("\"single\"", WindowsArgProtector.quote("single"), "quote") ? 0 : 1;
        failed += WindowsArgProtector.check("\"\\\"single\\\"\"", WindowsArgProtector.quote("\"single\""), "quote") ? 0 : 1;
        failed += WindowsArgProtector.check("\"/p:Configuration=\\\"StaticDebugMT (Unicode, MFC)\\\"\"", WindowsArgProtector.quote("/p:Configuration=\"StaticDebugMT (Unicode, MFC)\""), "quote") ? 0 : 1;
        failed += WindowsArgProtector.check("\"\"", WindowsArgProtector.quoteMaybe(""), "quoteMaybe") ? 0 : 1;
        failed += WindowsArgProtector.check("\"single\"", WindowsArgProtector.quoteMaybe("\"single\""), "quoteMaybe") ? 0 : 1;
        failed += WindowsArgProtector.check("single", WindowsArgProtector.quoteMaybe("single"), "quoteMaybe") ? 0 : 1;
        failed += WindowsArgProtector.check("o\"k", WindowsArgProtector.quoteMaybe("o\"k"), "quoteMaybe") ? 0 : 1;
        failed += WindowsArgProtector.check("\"o\\\"k e\"", WindowsArgProtector.quoteMaybe("o\"k e"), "quoteMaybe") ? 0 : 1;
        failed += WindowsArgProtector.check("\"one two\"", WindowsArgProtector.quoteMaybe("\"one two\""), "quoteMaybe") ? 0 : 1;
        failed += WindowsArgProtector.check("\"one two\"", WindowsArgProtector.quoteMaybe("one two"), "quoteMaybe") ? 0 : 1;
        System.out.println((failed += WindowsArgProtector.check("/p:Configuration=\"StaticDebugMT (Unicode, MFC)\"", WindowsArgProtector.quoteMaybe("/p:Configuration=\"StaticDebugMT (Unicode, MFC)\""), "quoteMaybe") ? 0 : 1) + " test(s) failed.");
    }

    private static boolean check(String expected, String actual, String name) {
        if (expected.equals(actual)) {
            System.out.println(name + " passed: " + actual);
            return true;
        }
        System.out.println(name + " failed: actual: " + actual + ", expected: " + expected);
        return false;
    }
}

