/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.Pair;
import com.fortify.util.XmlHandlerRelay;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmlInvalidCharacterFilter {
    private static boolean isValid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (XmlInvalidCharacterFilter.isValid(c)) continue;
            return false;
        }
        return true;
    }

    private static String sanitizeString(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!XmlInvalidCharacterFilter.isValid(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private static boolean isValid(char c) {
        if (c >= ' ' && c <= '\ud7ff') {
            return true;
        }
        if (c == '\n' || c == '\r' || c == '\t') {
            return true;
        }
        return c >= '\ue000' && c <= '\ufffd';
    }

    public static final class PathPart {
        public String name = null;
        public int index = -1;

        public void set(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        public static String fullPathToString(PathPart[] path, int pathLength) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < pathLength; ++i) {
                buf.append(path[i].toString());
                buf.append("/");
            }
            if (buf.length() == 0) {
                return "";
            }
            buf.setLength(buf.length() - 1);
            return buf.toString();
        }
    }

    public static interface Listener {
        public void observeInvalidContent(PathPart[] var1, int var2, char[] var3, int var4, int var5);

        public void observeInvalidAttributeValue(PathPart[] var1, int var2, String var3, String var4);
    }

    public static final class ReportingContentHandler
    extends ContentHandler {
        public final Listener listener;
        private PathPart[] path;
        private int pathLength;

        public ReportingContentHandler(Listener listener, org.xml.sax.ContentHandler handler) {
            super(handler);
            if (listener == null) {
                throw new NullPointerException("listener");
            }
            this.listener = listener;
            this.path = new PathPart[10];
            for (int i = 0; i < this.path.length; ++i) {
                this.path[i] = new PathPart();
            }
            this.pathLength = 0;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            if (this.pathLength + 2 >= this.path.length) {
                PathPart[] newPath = new PathPart[this.path.length * 2];
                System.arraycopy(this.path, 0, newPath, 0, this.path.length);
                for (int i = this.path.length; i < newPath.length; ++i) {
                    newPath[i] = new PathPart();
                }
                this.path = newPath;
            }
            this.path[this.pathLength].name = localName;
            ++this.path[this.pathLength].index;
            ++this.pathLength;
            super.startElement(namespaceURI, localName, qName, attrs);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.pathLength > 0) {
                this.path[this.pathLength + 1].index = -1;
                --this.pathLength;
            }
            super.endElement(namespaceURI, localName, qName);
        }

        @Override
        protected final void observeInvalidContent(char[] ch, int start, int length) {
            this.listener.observeInvalidContent(this.path, this.pathLength, ch, start, length);
        }

        @Override
        protected final void observeInvalidAttributeValue(String name, String value) {
            this.listener.observeInvalidAttributeValue(this.path, this.pathLength, name, value);
        }
    }

    public static class ContentHandler
    extends XmlHandlerRelay.ContentHandler {
        public ContentHandler(org.xml.sax.ContentHandler handler) {
            super(handler);
        }

        protected void observeInvalidContent(char[] ch, int start, int length) {
        }

        protected void observeInvalidAttributeValue(String name, String value) {
        }

        @Override
        public final void characters(char[] ch, int start, int length) throws SAXException {
            int end = start + length;
            int validCharsStart = start;
            boolean sawInvalidCharacter = false;
            for (int i = start; i < end; ++i) {
                char c = ch[i];
                if (XmlInvalidCharacterFilter.isValid(c)) continue;
                int validCharsCount = i - validCharsStart;
                if (validCharsCount > 0) {
                    char[] copy = new char[validCharsCount];
                    System.arraycopy(ch, validCharsStart, copy, 0, validCharsCount);
                    this.real.characters(copy, 0, validCharsCount);
                }
                validCharsStart = i + 1;
                sawInvalidCharacter = true;
            }
            int validCharsCount = end - validCharsStart;
            if (validCharsCount > 0) {
                if (validCharsCount == length) {
                    this.real.characters(ch, start, length);
                } else {
                    char[] copy = new char[validCharsCount];
                    System.arraycopy(ch, validCharsStart, copy, 0, validCharsCount);
                    this.real.characters(copy, 0, validCharsCount);
                }
            }
            if (sawInvalidCharacter) {
                this.observeInvalidContent(ch, start, length);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            attrs = this.sanitizeAttrs(attrs);
            this.real.startElement(namespaceURI, localName, qName, attrs);
        }

        private Attributes sanitizeAttrs(Attributes attrs) {
            int numAttrs = attrs.getLength();
            for (int i = 0; i < numAttrs; ++i) {
                if (XmlInvalidCharacterFilter.isValid(attrs.getValue(i))) continue;
                return this.sanitizeAttrs(i, attrs);
            }
            return attrs;
        }

        private Attributes sanitizeAttrs(int firstBad, Attributes attrs) {
            MyAttributes.Entry[] entries = new MyAttributes.Entry[attrs.getLength()];
            for (int i = 0; i < firstBad; ++i) {
                entries[i] = new MyAttributes.Entry(attrs, i);
            }
            String firstBadName = attrs.getLocalName(firstBad);
            String firstBadValue = attrs.getValue(firstBad);
            entries[firstBad] = new MyAttributes.Entry(attrs, firstBad, XmlInvalidCharacterFilter.sanitizeString(firstBadValue));
            this.observeInvalidAttributeValue(firstBadName, firstBadValue);
            for (int i = firstBad + 1; i < entries.length; ++i) {
                String lname = attrs.getLocalName(i);
                String value = attrs.getValue(i);
                if (!XmlInvalidCharacterFilter.isValid(value)) {
                    this.observeInvalidAttributeValue(lname, value);
                    value = XmlInvalidCharacterFilter.sanitizeString(value);
                }
                entries[i] = new MyAttributes.Entry(attrs, i, value);
            }
            return new MyAttributes(entries);
        }

        private static final class MyAttributes
        implements Attributes {
            public final Entry[] entryArray;
            public Map<String, Entry> qMap;
            public Map<Pair<String, String>, Entry> ulMap;

            public MyAttributes(Entry[] entries) {
                this.entryArray = entries;
                this.qMap = null;
            }

            private void ensureQMap() {
                if (this.qMap != null) {
                    return;
                }
                this.qMap = new HashMap<String, Entry>();
                for (int i = 0; i < this.entryArray.length; ++i) {
                    Entry e = this.entryArray[i];
                    this.qMap.put(e.qname, e);
                }
            }

            private void ensureULMap() {
                if (this.ulMap != null) {
                    return;
                }
                this.ulMap = new HashMap<Pair<String, String>, Entry>();
                for (int i = 0; i < this.entryArray.length; ++i) {
                    Entry e = this.entryArray[i];
                    this.ulMap.put(new Pair<String, String>(e.uri, e.lname), e);
                }
            }

            @Override
            public int getLength() {
                return this.entryArray.length;
            }

            @Override
            public String getURI(int i) {
                if (i > this.entryArray.length) {
                    return null;
                }
                return this.entryArray[i].uri;
            }

            @Override
            public String getLocalName(int i) {
                if (i > this.entryArray.length) {
                    return null;
                }
                return this.entryArray[i].lname;
            }

            @Override
            public String getQName(int i) {
                if (i > this.entryArray.length) {
                    return null;
                }
                return this.entryArray[i].qname;
            }

            @Override
            public String getType(int i) {
                if (i > this.entryArray.length) {
                    return null;
                }
                return this.entryArray[i].type;
            }

            @Override
            public String getValue(int i) {
                if (i > this.entryArray.length) {
                    return null;
                }
                return this.entryArray[i].value;
            }

            @Override
            public String getType(String qname) {
                this.ensureQMap();
                Entry e = this.qMap.get(qname);
                if (e == null) {
                    return null;
                }
                return e.type;
            }

            @Override
            public String getValue(String qname) {
                this.ensureQMap();
                Entry e = this.qMap.get(qname);
                if (e == null) {
                    return null;
                }
                return e.value;
            }

            @Override
            public int getIndex(String qName) {
                this.ensureQMap();
                Entry e = this.qMap.get(qName);
                if (e == null) {
                    return -1;
                }
                return e.index;
            }

            @Override
            public String getType(String uri, String localName) {
                this.ensureULMap();
                Entry e = this.ulMap.get(new Pair<String, String>(uri, localName));
                if (e == null) {
                    return null;
                }
                return e.type;
            }

            @Override
            public String getValue(String uri, String localName) {
                this.ensureULMap();
                Entry e = this.ulMap.get(new Pair<String, String>(uri, localName));
                if (e == null) {
                    return null;
                }
                return e.value;
            }

            @Override
            public int getIndex(String uri, String localName) {
                this.ensureULMap();
                Entry e = this.ulMap.get(new Pair<String, String>(uri, localName));
                if (e == null) {
                    return -1;
                }
                return e.index;
            }

            public static final class Entry {
                public final String uri;
                public final String lname;
                public final String qname;
                public final String value;
                public final String type;
                public final int index;

                public Entry(Attributes attr, int index) {
                    this(attr, index, attr.getValue(index));
                }

                public Entry(Attributes attr, int index, String value) {
                    this.uri = attr.getURI(index);
                    this.lname = attr.getLocalName(index);
                    this.qname = attr.getQName(index);
                    this.value = value;
                    this.type = attr.getType(index);
                    this.index = index;
                }
            }
        }
    }
}

