/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public final class XmlWriter {
    private final Stack tagStack;
    private final Writer out;
    private final Stack indentStack;
    private final String indentIncrement;
    private String currentIndent;
    private int state = 0;
    private String pendingLine = null;
    private static final int State_NORMAL = 0;
    private static final int State_OPEN_TAG = 1;
    private static final int State_SINGLE_LINE = 2;

    public XmlWriter(Writer out) {
        this.out = out;
        this.tagStack = new Stack();
        this.indentStack = null;
        this.currentIndent = null;
        this.indentIncrement = null;
    }

    public XmlWriter(Writer out, String indentStart, String indentIncrement) {
        this.out = out;
        this.tagStack = new Stack();
        this.indentStack = new Stack();
        this.currentIndent = indentStart;
        this.indentIncrement = indentIncrement;
    }

    public void leaf(String name) throws IOException {
        this.open(name, null);
        this.close();
    }

    public void leaf(String name, String text) throws IOException {
        this.open(name, null);
        this.line(text);
        this.close();
    }

    public void leaf(String name, Attrs attrs) throws IOException {
        this.open(name, attrs);
        this.close();
    }

    public void leaf(String name, Attrs attrs, String text) throws IOException {
        this.open(name, attrs);
        this.line(text);
        this.close();
    }

    public void open(String name) throws IOException {
        this.open(name, null);
    }

    public void open(String name, Attrs attrs) throws IOException {
        this.resetState();
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.currentIndent != null) {
            this.out.write(this.currentIndent);
        }
        this.out.write(60);
        this.out.write(name);
        if (attrs != null && attrs.values.size() > 0) {
            for (Map.Entry e : attrs.values.entrySet()) {
                this.out.write(32);
                this.out.write((String)e.getKey());
                this.out.write("=\"");
                this.writeAttribute((String)e.getValue());
                this.out.write(34);
            }
        }
        this.state = 1;
        if (this.currentIndent != null) {
            this.indentStack.push(this.currentIndent);
            this.currentIndent = this.currentIndent + this.indentIncrement;
        }
        this.tagStack.push(name);
    }

    public void line(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (this.state == 1) {
            this.pendingLine = s;
            this.state = 2;
            return;
        }
        this.resetState();
        if (this.currentIndent != null) {
            this.out.write(this.currentIndent);
        }
        this.writeText(s);
        if (this.currentIndent != null) {
            this.writeNewLine();
        }
    }

    private void resetState() throws IOException {
        if (this.state == 0) {
            return;
        }
        this.out.write(62);
        if (this.currentIndent != null) {
            this.writeNewLine();
        }
        if (this.state == 2) {
            if (this.currentIndent != null) {
                this.out.write(this.currentIndent);
            }
            this.writeText(this.pendingLine);
            this.pendingLine = null;
            if (this.currentIndent != null) {
                this.writeNewLine();
            }
        }
        this.state = 0;
    }

    public void close() throws IOException {
        if (this.tagStack.isEmpty()) {
            throw new RuntimeException("Empty tag stack (too many calls to close(...))");
        }
        String top = (String)this.tagStack.pop();
        this.writeCloseTag(top);
    }

    public void close(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.tagStack.isEmpty()) {
            throw new RuntimeException("Empty tag stack (too many calls to close(...)), name = " + StringUtil.toJavaAsciiLiteral(name));
        }
        String top = (String)this.tagStack.pop();
        if (!top.equals(name)) {
            throw new RuntimeException("Tag mismatch; caller expected " + StringUtil.toJavaAsciiLiteral(name) + ", top of stack contains " + StringUtil.toJavaAsciiLiteral(top));
        }
        this.writeCloseTag(top);
    }

    private void writeCloseTag(String name) throws IOException {
        if (this.state == 1) {
            this.out.write("/>");
            if (this.currentIndent != null) {
                this.writeNewLine();
                this.currentIndent = (String)this.indentStack.pop();
            }
        } else if (this.state == 2) {
            this.out.write(62);
            this.writeText(this.pendingLine);
            this.out.write("</");
            this.out.write(name);
            this.out.write(62);
            if (this.currentIndent != null) {
                this.writeNewLine();
                this.currentIndent = (String)this.indentStack.pop();
            }
        } else if (this.state == 0) {
            if (this.currentIndent != null) {
                this.currentIndent = (String)this.indentStack.pop();
                this.out.write(this.currentIndent);
            }
            this.out.write("</");
            this.out.write(name);
            this.out.write(62);
            if (this.currentIndent != null) {
                this.writeNewLine();
            }
        } else {
            throw this.badState();
        }
        this.state = 0;
    }

    private RuntimeException badState() {
        return new RuntimeException("bad state: " + this.state);
    }

    private void writeAttribute(String s) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    this.out.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.out.write("&gt;");
                    continue block6;
                }
                case '&': {
                    this.out.write("&amp;");
                    continue block6;
                }
                case '\"': {
                    this.out.write("&quot;");
                    continue block6;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
    }

    private void writeText(String s) throws IOException {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    this.out.write("&lt;");
                    continue block5;
                }
                case '>': {
                    this.out.write("&gt;");
                    continue block5;
                }
                case '&': {
                    this.out.write("&amp;");
                    continue block5;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
    }

    private void writeNewLine() throws IOException {
        this.out.write(SystemUtil.LINE_SEP);
    }

    public void flush() throws IOException {
        this.resetState();
        this.out.flush();
    }

    public static Attrs attr(String key, String value) {
        return new Attrs().attr(key, value);
    }

    public static void main(String[] args) throws IOException {
        XmlWriter w = new XmlWriter(new OutputStreamWriter(System.out), "", "  ");
        w.open("Goose", XmlWriter.attr("Name", "Chuck \"Roundhouse\" Norris & Co."));
        w.open("Beak");
        w.line("Orange & Black");
        w.close();
        w.open("Body");
        w.line("Scooby & \"Snack\"");
        w.open("Wings");
        w.close();
        w.close();
        w.close("Goose");
        w.flush();
    }

    public static final class Attrs {
        private final Map values = new LinkedHashMap();

        public Attrs attr(String key, String value) {
            String displaced = this.values.put(key, value);
            if (displaced != null) {
                throw new RuntimeException("Duplicate attribute: " + StringUtil.toJavaAsciiLiteral(key));
            }
            return this;
        }
    }
}

